package mekanism.generators.common.inventory.container;

import mekanism.common.inventory.slot.SlotEnergy.SlotCharge;
import mekanism.common.util.ChargeUtils;
import mekanism.generators.common.tile.TileEntityBioGenerator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidUtil;

public class ContainerBioGenerator extends Container
{
	private TileEntityBioGenerator tileEntity;

	public ContainerBioGenerator(InventoryPlayer inventory, TileEntityBioGenerator tentity)
	{
		tileEntity = tentity;
		func_75146_a(new Slot(tentity, 0, 17, 35));
		func_75146_a(new SlotCharge(tentity, 1, 143, 35));
		int slotX;

		for(slotX = 0; slotX < 3; ++slotX)
		{
			for(int slotY = 0; slotY < 9; ++slotY)
			{
				func_75146_a(new Slot(inventory, slotY + slotX * 9 + 9, 8 + slotY * 18, 84 + slotX * 18));
			}
		}

		for(slotX = 0; slotX < 9; ++slotX)
		{
			func_75146_a(new Slot(inventory, slotX, 8 + slotX * 18, 142));
		}

		tileEntity.func_174889_b(inventory.field_70458_d);
		tileEntity.open(inventory.field_70458_d);
	}

	@Override
	public void func_75134_a(EntityPlayer entityplayer)
	{
		super.func_75134_a(entityplayer);

		tileEntity.func_174886_c(entityplayer);
		tileEntity.close(entityplayer);
	}

	@Override
	public boolean func_75145_c(EntityPlayer entityplayer)
	{
		return tileEntity.func_70300_a(entityplayer);
	}

	@Override
	public ItemStack func_82846_b(EntityPlayer player, int slotID)
	{
		ItemStack stack = ItemStack.field_190927_a;
		Slot currentSlot = (Slot)field_75151_b.get(slotID);

		if(currentSlot != null && currentSlot.func_75216_d())
		{
			ItemStack slotStack = currentSlot.func_75211_c();
			stack = slotStack.func_77946_l();

			if(ChargeUtils.canBeCharged(slotStack))
			{
				if(slotID != 1)
				{
					if(!func_75135_a(slotStack, 1, 2, false))
					{
						return ItemStack.field_190927_a;
					}
				}
				else if(slotID == 1)
				{
					if(!func_75135_a(slotStack, 2, field_75151_b.size(), false))
					{
						return ItemStack.field_190927_a;
					}
				}
			}
			else if(tileEntity.getFuel(slotStack) > 0 || isBiofuel(slotStack))
			{
				if(slotID != 0 && slotID != 1)
				{
					if (!func_75135_a(slotStack, 0, 1, false))
					{
						return ItemStack.field_190927_a;
					}
				}
				else {
					if(!func_75135_a(slotStack, 2, field_75151_b.size(), true))
					{
						return ItemStack.field_190927_a;
					}
				}
			}
			else {
				if(slotID >= 2 && slotID <= 28)
				{
					if(!func_75135_a(slotStack, 29, field_75151_b.size(), false))
					{
						return ItemStack.field_190927_a;
					}
				}
				else if(slotID > 28)
				{
					if(!func_75135_a(slotStack, 2, 28, false))
					{
						return ItemStack.field_190927_a;
					}
				}
				else {
					if(!func_75135_a(slotStack, 2, field_75151_b.size(), true))
					{
						return ItemStack.field_190927_a;
					}
				}
			}

			if(slotStack.func_190916_E() == 0)
			{
				currentSlot.func_75215_d(ItemStack.field_190927_a);
			}
			else {
				currentSlot.func_75218_e();
			}

			if(slotStack.func_190916_E() == stack.func_190916_E())
			{
				return ItemStack.field_190927_a;
			}

			currentSlot.func_190901_a(player, slotStack);
		}

		return stack;
	}

	private boolean isBiofuel(ItemStack itemStack)
	{
		if(FluidRegistry.isFluidRegistered("bioethanol"))
		{
			return FluidUtil.getFluidContained(itemStack) != null && FluidUtil.getFluidContained(itemStack).getFluid() == FluidRegistry.getFluid("bioethanol");
		}

		return false;
	}
}
