package mekanism.generators.common.content.turbine;

import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.tile.TileEntityGasTank.GasMode;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class TurbineCache extends MultiblockCache<SynchronizedTurbineData>
{
	public FluidStack fluid;
	public double electricity;
	public GasMode dumpMode = GasMode.IDLE;
	
	@Override
	public void apply(SynchronizedTurbineData data)
	{
		data.fluidStored = fluid;
		data.electricityStored = electricity;
		data.dumpMode = dumpMode;
	}

	@Override
	public void sync(SynchronizedTurbineData data) 
	{
		fluid = data.fluidStored;
		electricity = data.electricityStored;
		dumpMode = data.dumpMode;
	}

	@Override
	public void load(NBTTagCompound nbtTags) 
	{
		if(nbtTags.func_74764_b("cachedFluid"))
		{
			fluid = FluidStack.loadFluidStackFromNBT(nbtTags.func_74775_l("cachedFluid"));
		}
		
		electricity = nbtTags.func_74769_h("electricity");
		dumpMode = GasMode.values()[nbtTags.func_74762_e("dumpMode")];
	}

	@Override
	public void save(NBTTagCompound nbtTags) 
	{
		if(fluid != null)
		{
			nbtTags.func_74782_a("cachedFluid", fluid.writeToNBT(new NBTTagCompound()));
		}
		
		nbtTags.func_74780_a("electricity", electricity);
		nbtTags.func_74768_a("dumpMode", dumpMode.ordinal());
	}
}
