package mekanism.generators.common.block;

import mekanism.common.Mekanism;
import mekanism.common.base.IActiveState;
import mekanism.common.tile.prefab.TileEntityBasicBlock;
import mekanism.common.tile.prefab.TileEntityElectricBlock;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.GeneratorsBlocks;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.block.states.BlockStateReactor;
import mekanism.generators.common.block.states.BlockStateReactor.ReactorBlock;
import mekanism.generators.common.block.states.BlockStateReactor.ReactorBlockType;
import mekanism.generators.common.tile.reactor.TileEntityReactorController;
import mekanism.generators.common.tile.reactor.TileEntityReactorLogicAdapter;
import mekanism.generators.common.tile.reactor.TileEntityReactorPort;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import buildcraft.api.tools.IToolWrench;

public abstract class BlockReactor extends Block implements ITileEntityProvider
{

	public BlockReactor()
	{
		super(Material.field_151573_f);
		func_149711_c(3.5F);
		func_149752_b(8F);
		func_149647_a(Mekanism.tabMekanism);
	}
	
	public static BlockReactor getReactorBlock(ReactorBlock block)
	{
		return new BlockReactor()
		{
			@Override
			public ReactorBlock getReactorBlock()
			{
				return block;
			}
		};
	}

	public abstract ReactorBlock getReactorBlock();
	
	@Override
	public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos)
	{
		TileEntity tile = MekanismUtils.getTileEntitySafe(worldIn, pos);
		
		if(tile instanceof TileEntityReactorController)
		{
			state = state.func_177226_a(BlockStateReactor.activeProperty, ((IActiveState)tile).getActive());
		}
		
		if(tile instanceof TileEntityReactorPort)
		{
			state = state.func_177226_a(BlockStateReactor.activeProperty, ((TileEntityReactorPort)tile).fluidEject);
		}
		
		return state;
	}
	
	@Override
	public BlockStateContainer func_180661_e()
	{
		return new BlockStateReactor(this, getTypeProperty());
	}

	@Override
	public IBlockState func_176203_a(int meta)
	{
		ReactorBlockType type = ReactorBlockType.get(getReactorBlock(), meta & 0xF);

		return func_176223_P().func_177226_a(getTypeProperty(), type);
	}

	@Override
	public int func_176201_c(IBlockState state)
	{
		ReactorBlockType type = state.func_177229_b(getTypeProperty());
		return type.meta;
	}

	@Override
	public int func_180651_a(IBlockState state)
	{
		return state.func_177230_c().func_176201_c(state);
	}

	@Override
	public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos neighborPos)
	{
		if(!world.field_72995_K)
		{
			TileEntity tileEntity = world.func_175625_s(pos);

			if(tileEntity instanceof TileEntityBasicBlock)
			{
				((TileEntityBasicBlock)tileEntity).onNeighborChange(neighborBlock);
			}
		}
	}

	@Override
	public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityplayer, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ)
	{
		if(world.field_72995_K)
		{
			return true;
		}

		TileEntityElectricBlock tileEntity = (TileEntityElectricBlock)world.func_175625_s(pos);
		int metadata = state.func_177230_c().func_176201_c(state);
		ItemStack stack = entityplayer.func_184586_b(hand);

		if(!stack.func_190926_b())
		{
			if(MekanismUtils.isBCWrench(stack.func_77973_b()) && !stack.func_77977_a().contains("omniwrench"))
			{
				if(entityplayer.func_70093_af())
				{
					dismantleBlock(world, pos, false);
					return true;
				}

				((IToolWrench)stack.func_77973_b()).wrenchUsed(entityplayer, hand, stack, new RayTraceResult(new Vec3d(hitX, hitY, hitZ), side, pos));

				return true;
			}
		}

		if(tileEntity instanceof TileEntityReactorController)
		{
			if(!entityplayer.func_70093_af())
			{
				entityplayer.openGui(MekanismGenerators.instance, ReactorBlockType.get(this, metadata).guiId, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
				return true;
			}
		}
		
		if(tileEntity instanceof TileEntityReactorLogicAdapter)
		{
			if(!entityplayer.func_70093_af())
			{
				entityplayer.openGui(MekanismGenerators.instance, BlockStateReactor.ReactorBlockType.get(this, metadata).guiId, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
				return true;
			}
		}

		return false;
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void func_149666_a(Item item, CreativeTabs creativetabs, NonNullList<ItemStack> list)
	{
		for(BlockStateReactor.ReactorBlockType type : BlockStateReactor.ReactorBlockType.values())
		{
			if(type.blockType == getReactorBlock())
			{
				list.add(new ItemStack(item, 1, type.meta));
			}
		}
	}

	@Override
	public TileEntity createTileEntity(World world, IBlockState state)
	{
		int metadata = state.func_177230_c().func_176201_c(state);
		
		if(ReactorBlockType.get(getReactorBlock(), metadata) == null)
		{
			return null;
		}

		return ReactorBlockType.get(getReactorBlock(), metadata).create();
	}
	
	@Override
	public BlockRenderLayer func_180664_k()
	{
		return this == GeneratorsBlocks.Reactor ? BlockRenderLayer.CUTOUT : BlockRenderLayer.TRANSLUCENT;
	}

	@Override
	public EnumBlockRenderType func_149645_b(IBlockState state)
	{
		return EnumBlockRenderType.MODEL;
	}

	@Override
	public boolean func_149662_c(IBlockState state)
	{
		return false;
	}
	
	@Override
	public boolean func_149686_d(IBlockState state)
	{
		return false;
	}

	/*This method is not used, metadata manipulation is required to create a Tile Entity.*/
	@Override
	public TileEntity func_149915_a(World world, int meta)
	{
		return null;
	}
	
	@Override
	@SideOnly(Side.CLIENT)
	public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side)
	{
		int meta = state.func_177230_c().func_176201_c(state);
		ReactorBlockType type = ReactorBlockType.get(getReactorBlock(), meta);
		
		if(type == ReactorBlockType.REACTOR_GLASS || type == ReactorBlockType.LASER_FOCUS_MATRIX)
		{
			IBlockState stateOffset = world.func_180495_p(pos.func_177972_a(side));
			if(this == stateOffset.func_177230_c()) {
				int metaOffset = stateOffset.func_177230_c().func_176201_c(stateOffset);
				ReactorBlockType typeOffset = ReactorBlockType.get(getReactorBlock(), metaOffset);
				if (typeOffset == ReactorBlockType.REACTOR_GLASS || typeOffset == ReactorBlockType.LASER_FOCUS_MATRIX) {
					return false;
				}
			}
		}
			
		return super.func_176225_a(state, world, pos, side);
	}
	
	@Override
	public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side)
    {
		TileEntity tile = MekanismUtils.getTileEntitySafe(world, pos);
		
		if(tile instanceof TileEntityReactorLogicAdapter)
		{
			return ((TileEntityReactorLogicAdapter)tile).checkMode() ? 15 : 0;
		}
		
        return 0;
    }
	
	@Override
	public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side)
	{
		ReactorBlockType type = ReactorBlockType.get(getReactorBlock(), state.func_177230_c().func_176201_c(state));

		switch(type)
		{
			case REACTOR_FRAME:
			case REACTOR_PORT:
			case REACTOR_LOGIC_ADAPTER:
				return true;
			default:
				return false;
		}
	}

	@Override
	public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side)
	{
		ReactorBlockType type = BlockStateReactor.ReactorBlockType.get(this, state.func_177230_c().func_176201_c(state));

		switch(type)
		{
			case REACTOR_LOGIC_ADAPTER:
				return true;
			default:
				return false;
		}
	}

	public ItemStack dismantleBlock(World world, BlockPos pos, boolean returnBlock)
	{
		IBlockState state = world.func_180495_p(pos);
		ItemStack itemStack = new ItemStack(this, 1, state.func_177230_c().func_176201_c(state));

		world.func_175698_g(pos);

		if(!returnBlock)
		{
			float motion = 0.7F;
			double motionX = (world.field_73012_v.nextFloat() * motion) + (1.0F - motion) * 0.5D;
			double motionY = (world.field_73012_v.nextFloat() * motion) + (1.0F - motion) * 0.5D;
			double motionZ = (world.field_73012_v.nextFloat() * motion) + (1.0F - motion) * 0.5D;

			EntityItem entityItem = new EntityItem(world, pos.func_177958_n() + motionX, pos.func_177956_o() + motionY, pos.func_177952_p() + motionZ, itemStack);

			world.func_72838_d(entityItem);
		}

		return itemStack;
	}

	public PropertyEnum<ReactorBlockType> getTypeProperty()
	{
		return getReactorBlock().getProperty();
	}
}
