package mekanism.generators.client.render.item;

import java.util.List;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

import com.google.common.collect.Lists;

public class GeneratorItemModelFactory implements IBakedModel
{
	private IBakedModel baseModel;
	
	private GeneratorOverride override = new GeneratorOverride();
	
	public GeneratorItemModelFactory(IBakedModel base)
	{
		baseModel = base;
	}
	
	@Override
	public ItemOverrideList func_188617_f()
	{
		return override;
	}
	
	@Override
	public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing facing, long rand) 
	{
		throw new UnsupportedOperationException();
	}

	@Override
	public boolean func_177555_b() 
	{
		throw new UnsupportedOperationException();
	}

	@Override
	public boolean func_177556_c() 
	{
		return baseModel.func_177556_c();
	}

	@Override
	public boolean func_188618_c() 
	{
		throw new UnsupportedOperationException();
	}

	@Override
	public TextureAtlasSprite func_177554_e() 
	{
		throw new UnsupportedOperationException();
	}

	@Override
	public ItemCameraTransforms func_177552_f() 
	{
		throw new UnsupportedOperationException();
	}
	
	private class GeneratorOverride extends ItemOverrideList 
    {
		public GeneratorOverride() 
		{
			super(Lists.newArrayList());
		}

	    @Override
	    public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) 
	    {
	    	return new BakedGeneratorItemModel(baseModel, stack);
	    }
	}
}
