package mekanism.generators.client.render;

import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import mekanism.generators.client.model.ModelWindGenerator;
import mekanism.generators.common.tile.TileEntityWindGenerator;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;

public class RenderWindGenerator extends TileEntitySpecialRenderer<TileEntityWindGenerator>
{
	private ModelWindGenerator model = new ModelWindGenerator();

	@Override
	public void func_180535_a(TileEntityWindGenerator tileEntity, double x, double y, double z, float partialTick, int destroyStage)
	{
		GlStateManager.func_179094_E();
		GlStateManager.func_179109_b((float)x + 0.5F, (float)y + 1.5F, (float)z + 0.5F);
		func_147499_a(MekanismUtils.getResource(ResourceType.RENDER, "WindGenerator.png"));

		switch(tileEntity.facing.ordinal())
		{
			case 2: GlStateManager.func_179114_b(0, 0.0F, 1.0F, 0.0F); break;
			case 3: GlStateManager.func_179114_b(180, 0.0F, 1.0F, 0.0F); break;
			case 4: GlStateManager.func_179114_b(90, 0.0F, 1.0F, 0.0F); break;
			case 5: GlStateManager.func_179114_b(270, 0.0F, 1.0F, 0.0F); break;
		}

		GlStateManager.func_179114_b(180, 0F, 0F, 1F);

		double angle = tileEntity.angle;
		
		if(tileEntity.isActive)
		{
			angle = (tileEntity.angle+((tileEntity.func_174877_v().func_177956_o()+4F)/TileEntityWindGenerator.SPEED_SCALED)*partialTick)%360;
		}

		model.render(0.0625F, angle);
		GlStateManager.func_179121_F();
	}
}
