package mekanism.generators.client.render;

import java.util.HashMap;
import java.util.Map;

import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.MekanismRenderer.DisplayInteger;
import mekanism.client.render.MekanismRenderer.Model3D;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import mekanism.generators.client.model.ModelBioGenerator;
import mekanism.generators.common.tile.TileEntityBioGenerator;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class RenderBioGenerator extends TileEntitySpecialRenderer<TileEntityBioGenerator>
{
	private ModelBioGenerator model = new ModelBioGenerator();

	private Map<EnumFacing, DisplayInteger[]> energyDisplays = new HashMap<EnumFacing, DisplayInteger[]>();

	private static final int stages = 40;

	@Override
	public void func_180535_a(TileEntityBioGenerator tileEntity, double x, double y, double z, float partialTick, int destroyStage)
	{
		if(tileEntity.bioFuelSlot.fluidStored > 0)
		{
			push();

			MekanismRenderer.glowOn();
			GlStateManager.func_179109_b((float)x, (float)y, (float)z);
			func_147499_a(MekanismRenderer.getBlocksTexture());
			getDisplayList(tileEntity.facing)[tileEntity.getScaledFuelLevel(stages-1)].render();
			MekanismRenderer.glowOff();

			pop();
		}
		
		GlStateManager.func_179094_E();
		GlStateManager.func_179109_b((float)x + 0.5F, (float)y + 1.5F, (float)z + 0.5F);
		func_147499_a(MekanismUtils.getResource(ResourceType.RENDER, "BioGenerator.png"));

		switch(tileEntity.facing.ordinal())
		{
			case 2: GlStateManager.func_179114_b(180, 0.0F, 1.0F, 0.0F); break;
			case 3: GlStateManager.func_179114_b(0, 0.0F, 1.0F, 0.0F); break;
			case 4: GlStateManager.func_179114_b(270, 0.0F, 1.0F, 0.0F); break;
			case 5: GlStateManager.func_179114_b(90, 0.0F, 1.0F, 0.0F); break;
		}
		
		GlStateManager.func_179114_b(180, 0F, 0F, 1F);
		model.render(0.0625F);
		GlStateManager.func_179121_F();
	}

	@SuppressWarnings("incomplete-switch")
	private DisplayInteger[] getDisplayList(EnumFacing side)
	{
		if(energyDisplays.containsKey(side))
		{
			return energyDisplays.get(side);
		}

		DisplayInteger[] displays = new DisplayInteger[stages];

		Model3D model3D = new Model3D();
		model3D.baseBlock = Blocks.field_150355_j;
		model3D.setTexture(MekanismRenderer.energyIcon);

		for(int i = 0; i < stages; i++)
		{
			displays[i] = DisplayInteger.createAndStart();

			switch(side)
			{
				case NORTH:
				{
					model3D.minZ = 0.5;
					model3D.maxZ = 0.875;

					model3D.minX = 0.1875;
					model3D.maxX = 0.8215;
					model3D.minY = 0.4375;
					model3D.maxY = 0.4375 + ((float)i/stages)*0.4375;
					break;
				}
				case SOUTH:
				{
					model3D.minZ = 0.125;
					model3D.maxZ = 0.5;

					model3D.minX = 0.1875;
					model3D.maxX = 0.8215;
					model3D.minY = 0.4375;
					model3D.maxY = 0.4375 + ((float)i/stages)*0.4375;
					break;
				}
				case WEST:
				{
					model3D.minX = 0.5;
					model3D.maxX = 0.875;

					model3D.minZ = 0.1875;
					model3D.maxZ = 0.8215;
					model3D.minY = 0.4375;
					model3D.maxY = 0.4375 + ((float)i/stages)*0.4375;
					break;
				}
				case EAST:
				{
					model3D.minX = 0.125;
					model3D.maxX = 0.5;

					model3D.minZ = 0.1875;
					model3D.maxZ = 0.8215;
					model3D.minY = 0.4375;
					model3D.maxY = 0.4375 + ((float)i/stages)*0.4375;
					break;
				}
			}

			MekanismRenderer.renderObject(model3D);
			displays[i].endList();
		}

		energyDisplays.put(side, displays);

		return displays;
	}

	private void pop()
	{
		GL11.glPopAttrib();
		GlStateManager.func_179121_F();
	}

	private void push()
	{
		GlStateManager.func_179094_E();
		GL11.glPushAttrib(GL11.GL_ENABLE_BIT);
		GL11.glEnable(GL11.GL_CULL_FACE);
		GL11.glEnable(GL11.GL_BLEND);
		GL11.glDisable(GL11.GL_LIGHTING);
		GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
	}
}
