package mekanism.generators.client.model;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;

public class ModelWindGenerator extends ModelBase 
{
	ModelRenderer head;
	ModelRenderer plateConnector2;
	ModelRenderer plateConnector;
	ModelRenderer plate;
	ModelRenderer bladeCap;
	ModelRenderer bladeCenter;
	ModelRenderer baseRim;
	ModelRenderer base;
	ModelRenderer wire;
	ModelRenderer rearPlate1;
	ModelRenderer rearPlate2;
	ModelRenderer blade1a;
	ModelRenderer blade2a;
	ModelRenderer blade3a;
	ModelRenderer blade1b;
	ModelRenderer blade2b;
	ModelRenderer blade3b;
	ModelRenderer post1a;
	ModelRenderer post1b;
	ModelRenderer post1c;
	ModelRenderer post1d;

	public ModelWindGenerator()
	{
		field_78090_t = 128;
		field_78089_u = 128;

		head = new ModelRenderer(this, 20, 0);
		head.func_78789_a(-3.5F, -3.5F, 0F, 7, 7, 9);
		head.func_78793_a(0F, -48F, -4F);
		head.func_78787_b(128, 128);
		head.field_78809_i = true;
		setRotation(head, 0F, 0F, 0F);
		plateConnector2 = new ModelRenderer(this, 42, 34);
		plateConnector2.func_78789_a(0F, 0F, 0F, 6, 6, 10);
		plateConnector2.func_78793_a(-3F, 13F, -7F);
		plateConnector2.func_78787_b(128, 128);
		plateConnector2.field_78809_i = true;
		setRotation(plateConnector2, 0F, 0F, 0F);
		plateConnector = new ModelRenderer(this, 0, 75);
		plateConnector.func_78789_a(0F, 0F, 0F, 4, 2, 2);
		plateConnector.func_78793_a(-2F, 19F, -5.5F);
		plateConnector.func_78787_b(128, 128);
		plateConnector.field_78809_i = true;
		setRotation(plateConnector, 0F, 0F, 0F);
		plate = new ModelRenderer(this, 42, 25);
		plate.func_78789_a(0F, 0F, 0F, 8, 8, 1);
		plate.func_78793_a(-4F, 12F, -8F);
		plate.func_78787_b(128, 128);
		plate.field_78809_i = true;
		setRotation(plate, 0F, 0F, 0F);
		bladeCap = new ModelRenderer(this, 22, 0);
		bladeCap.func_78789_a(-1F, -1F, -8F, 2, 2, 1);
		bladeCap.func_78793_a(0F, -48F, 0F);
		bladeCap.func_78787_b(128, 128);
		bladeCap.field_78809_i = true;
		setRotation(bladeCap, 0F, 0F, 0F);
		bladeCenter = new ModelRenderer(this, 20, 25);
		bladeCenter.func_78789_a(-2F, -2F, -7F, 4, 4, 3);
		bladeCenter.func_78793_a(0F, -48F, 0F);
		bladeCenter.func_78787_b(128, 128);
		bladeCenter.field_78809_i = true;
		setRotation(bladeCenter, 0F, 0F, 0F);
		baseRim = new ModelRenderer(this, 26, 50);
		baseRim.func_78789_a(0F, 0F, 0F, 12, 2, 12);
		baseRim.func_78793_a(-6F, 21F, -6F);
		baseRim.func_78787_b(128, 128);
		baseRim.field_78809_i = true;
		setRotation(baseRim, 0F, 0F, 0F);
		base = new ModelRenderer(this, 10, 64);
		base.func_78789_a(0F, 0F, 0F, 16, 2, 16);
		base.func_78793_a(-8F, 22F, -8F);
		base.func_78787_b(128, 128);
		base.field_78809_i = true;
		setRotation(base, 0F, 0F, 0F);
		wire = new ModelRenderer(this, 74, 0);
		wire.func_78789_a(-1F, 0F, -1.1F, 2, 65, 2);
		wire.func_78793_a(0F, -46F, -1.5F);
		wire.func_78787_b(128, 128);
		wire.field_78809_i = true;
		setRotation(wire, -0.0349066F, 0F, 0F);
		rearPlate1 = new ModelRenderer(this, 20, 16);
		rearPlate1.func_78789_a(-2.5F, -6F, 0F, 5, 6, 3);
		rearPlate1.func_78793_a(0F, -44.5F, 4F);
		rearPlate1.func_78787_b(128, 128);
		rearPlate1.field_78809_i = true;
		setRotation(rearPlate1, 0.122173F, 0F, 0F);
		rearPlate2 = new ModelRenderer(this, 36, 16);
		rearPlate2.func_78789_a(-1.5F, -5F, -1F, 3, 5, 2);
		rearPlate2.func_78793_a(0F, -45F, 7F);
		rearPlate2.func_78787_b(128, 128);
		rearPlate2.field_78809_i = true;
		setRotation(rearPlate2, 0.2094395F, 0F, 0F);
		blade1a = new ModelRenderer(this, 20, 32);
		blade1a.func_78789_a(-1F, -32F, 0F, 2, 32, 1);
		blade1a.func_78793_a(0F, -48F, -5.99F);
		blade1a.func_78787_b(128, 128);
		blade1a.field_78809_i = true;
		setRotation(blade1a, 0F, 0F, 0F);
		blade2a = new ModelRenderer(this, 20, 32);
		blade2a.func_78789_a(-1F, 0F, 0F, 2, 32, 1);
		blade2a.func_78793_a(0F, -48F, -6F);
		blade2a.func_78787_b(128, 128);
		blade2a.field_78809_i = true;
		setRotation(blade2a, 0F, 0F, 1.047198F);
		blade3a = new ModelRenderer(this, 20, 32);
		blade3a.func_78789_a(-1F, 0F, 0F, 2, 32, 1);
		blade3a.func_78793_a(0F, -48F, -6F);
		blade3a.func_78787_b(128, 128);
		blade3a.field_78809_i = true;
		setRotation(blade3a, 0F, 0F, -1.047198F);
		blade1b = new ModelRenderer(this, 26, 32);
		blade1b.func_78789_a(-2F, -28F, 0F, 2, 28, 1);
		blade1b.func_78793_a(0F, -48F, -6F);
		blade1b.func_78787_b(128, 128);
		blade1b.field_78809_i = true;
		setRotation(blade1b, 0F, 0F, 0.0349066F);
		blade2b = new ModelRenderer(this, 26, 32);
		blade2b.func_78789_a(0F, 0F, 0F, 2, 28, 1);
		blade2b.func_78793_a(0F, -48F, -6.01F);
		blade2b.func_78787_b(128, 128);
		blade2b.field_78809_i = true;
		setRotation(blade2b, 0F, 0F, 1.082104F);
		blade3b = new ModelRenderer(this, 26, 32);
		blade3b.func_78789_a(0F, 0F, 0F, 2, 28, 1);
		blade3b.func_78793_a(0F, -48F, -6.01F);
		blade3b.func_78787_b(128, 128);
		blade3b.field_78809_i = true;
		setRotation(blade3b, 0F, 0F, -1.012291F);
		post1a = new ModelRenderer(this, 0, 0);
		post1a.func_78789_a(-2.5F, 0F, -2.5F, 5, 68, 5);
		post1a.func_78793_a(0F, -46F, 0F);
		post1a.func_78787_b(128, 128);
		post1a.field_78809_i = true;
		setRotation(post1a, -0.0349066F, 0F, 0.0349066F);
		post1b = new ModelRenderer(this, 0, 0);
		post1b.func_78789_a(-2.5F, 0F, -2.5F, 5, 68, 5);
		post1b.func_78793_a(0F, -46F, 0F);
		post1b.func_78787_b(128, 128);
		post1b.field_78809_i = true;
		setRotation(post1b, 0.0349066F, 0F, -0.0349066F);
		post1c = new ModelRenderer(this, 0, 0);
		post1c.func_78789_a(-2.5F, 0F, -2.5F, 5, 68, 5);
		post1c.func_78793_a(0F, -46F, 0F);
		post1c.func_78787_b(128, 128);
		post1c.field_78809_i = true;
		setRotation(post1c, 0.0347321F, 0F, 0.0347321F);
		post1d = new ModelRenderer(this, 0, 0);
		post1d.func_78789_a(-2.5F, 0F, -2.5F, 5, 68, 5);
		post1d.func_78793_a(0F, -46F, 0F);
		post1d.func_78787_b(128, 128);
		post1d.field_78809_i = true;
		setRotation(post1d, -0.0347321F, 0F, -0.0347321F);
	}

	public void render(float size, double angle) 
	{
		head.func_78785_a(size);
		plateConnector2.func_78785_a(size);
		plateConnector.func_78785_a(size);
		plate.func_78785_a(size);
		baseRim.func_78785_a(size);
		base.func_78785_a(size);
		wire.func_78785_a(size);
		rearPlate1.func_78785_a(size);
		rearPlate2.func_78785_a(size);
		post1a.func_78785_a(size);
		post1b.func_78785_a(size);
		post1c.func_78785_a(size);
		post1d.func_78785_a(size);
		
		setRotation(blade1a, 0F, 0F, getRotation(getAbsoluteAngle(angle)));
		setRotation(blade1b, 0F, 0F, 0.0349066F + getRotation(getAbsoluteAngle(angle)));
		
		setRotation(blade2a, 0F, 0F, getRotation(getAbsoluteAngle(angle - 60)));
		setRotation(blade2b, 0F, 0F, 0.0349066F + getRotation(getAbsoluteAngle(angle - 60)));
		
		setRotation(blade3a, 0F, 0F, getRotation(getAbsoluteAngle(angle + 60)));
		setRotation(blade3b, 0F, 0F, 0.0349066F + getRotation(getAbsoluteAngle(angle + 60)));
		
		setRotation(bladeCap, 0F, 0F, getRotation(getAbsoluteAngle(angle)));
		setRotation(bladeCenter, 0F, 0F, getRotation(getAbsoluteAngle(angle)));
		
		blade1a.func_78785_a(size);
		blade2a.func_78785_a(size);
		blade3a.func_78785_a(size);
		blade1b.func_78785_a(size);
		blade2b.func_78785_a(size);
		blade3b.func_78785_a(size);
		
		bladeCap.func_78785_a(size);
		bladeCenter.func_78785_a(size);
	}

	public float getRotation(double angle) 
	{
		return ((float)angle / (float) 180) * (float)Math.PI;
	}

	public double getAbsoluteAngle(double angle) 
	{
		return angle % 360;
	}

	private void setRotation(ModelRenderer model, float x, float y, float z) 
	{
		model.field_78795_f = x;
		model.field_78796_g = y;
		model.field_78808_h = z;
	}
}
