package mekanism.generators.client.model;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;

public class ModelTurbine extends ModelBase 
{
	private static float BLADE_ROTATE = 0.418879F;
	
    public ModelRenderer rod;
    public ModelRenderer extension_north;
    public ModelRenderer blade_north;
    public ModelRenderer extension_south;
    public ModelRenderer extension_west;
    public ModelRenderer extension_east;
    public ModelRenderer blade_south;
    public ModelRenderer blade_east;
    public ModelRenderer blade_west;

    public ModelTurbine() 
    {
        field_78090_t = 64;
        field_78089_u = 64;
        extension_south = new ModelRenderer(this, 0, 0);
        extension_south.func_78793_a(0.0F, 20.0F, 0.0F);
        extension_south.func_78790_a(-1.0F, 0.0F, 1.0F, 2, 1, 3, 0.0F);
        setRotateAngle(extension_south, 0.0F, 0.0F, -BLADE_ROTATE);
        extension_west = new ModelRenderer(this, 0, 4);
        extension_west.func_78793_a(0.0F, 20.0F, 0.0F);
        extension_west.func_78790_a(-4.0F, 0.0F, -1.0F, 3, 1, 2, 0.0F);
        setRotateAngle(extension_west, BLADE_ROTATE, 0.0F, 0.0F);
        blade_east = new ModelRenderer(this, 10, 5);
        blade_east.func_78793_a(0.0F, 20.0F, 0.0F);
        blade_east.func_78790_a(4.0F, 0.0F, -1.5F, 4, 1, 3, 0.0F);
        setRotateAngle(blade_east, -BLADE_ROTATE, 0.0F, 0.0F);
        blade_north = new ModelRenderer(this, 10, 0);
        blade_north.func_78793_a(0.0F, 20.0F, 0.0F);
        blade_north.func_78790_a(-1.5F, 0.0F, -8.0F, 3, 1, 4, 0.0F);
        setRotateAngle(blade_north, 0.0F, 0.0F, BLADE_ROTATE);
        extension_east = new ModelRenderer(this, 0, 4);
        extension_east.func_78793_a(0.0F, 20.0F, 0.0F);
        extension_east.func_78790_a(1.0F, 0.0F, -1.0F, 3, 1, 2, 0.0F);
        setRotateAngle(extension_east, -BLADE_ROTATE, 0.0F, 0.0F);
        rod = new ModelRenderer(this, 0, 44);
        rod.func_78793_a(-2.0F, 8.0F, -2.0F);
        rod.func_78790_a(0.0F, 0.0F, 0.0F, 4, 16, 4, 0.0F);
        blade_south = new ModelRenderer(this, 10, 0);
        blade_south.func_78793_a(0.0F, 20.0F, 0.0F);
        blade_south.func_78790_a(-1.5F, 0.0F, 4.0F, 3, 1, 4, 0.0F);
        setRotateAngle(blade_south, 0.0F, 0.0F, -BLADE_ROTATE);
        extension_north = new ModelRenderer(this, 0, 0);
        extension_north.func_78793_a(0.0F, 20.0F, 0.0F);
        extension_north.func_78790_a(-1.0F, 0.0F, -4.0F, 2, 1, 3, 0.0F);
        setRotateAngle(extension_north, 0.0F, 0.0F, BLADE_ROTATE);
        blade_west = new ModelRenderer(this, 10, 5);
        blade_west.func_78793_a(0.0F, 20.0F, 0.0F);
        blade_west.func_78790_a(-8.0F, 0.0F, -1.5F, 4, 1, 3, 0.0F);
        setRotateAngle(blade_west, BLADE_ROTATE, 0.0F, 0.0F);
    }

    public void render(float size, int index) 
    {
    	GlStateManager.func_179094_E();
    	
    	GlStateManager.func_179114_b(index*5, 0.0F, 1.0F, 0.0F);
    	
    	float scale = index*0.5F;
    	float widthDiv = 16;
    	
        extension_south.func_78785_a(size);
        extension_west.func_78785_a(size);
        extension_east.func_78785_a(size);
        extension_north.func_78785_a(size);
        
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b(-0.25F, 0.0F, 0.0F);
        GlStateManager.func_179152_a(1.0F + scale, 1.0F, 1.0F + scale/widthDiv);
        GlStateManager.func_179109_b(0.25F, 0.0F, 0.0F);
        blade_west.func_78785_a(size);
        GlStateManager.func_179121_F();
        
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b(0.25F, 0.0F, 0.0F);
        GlStateManager.func_179152_a(1.0F + scale, 1.0F, 1.0F + scale/widthDiv);
        GlStateManager.func_179109_b(-0.25F, 0.0F, 0.0F);
        blade_east.func_78785_a(size);
        GlStateManager.func_179121_F();
        
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b(0.0F, 0.0F, -0.25F);
        GlStateManager.func_179152_a(1.0F + scale/widthDiv, 1.0F, 1.0F + scale);
        GlStateManager.func_179109_b(0.0F, 0.0F, 0.25F);
        blade_north.func_78785_a(size);
        GlStateManager.func_179121_F();
        
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b(0.0F, 0.0F, 0.25F);
        GlStateManager.func_179152_a(1.0F + scale/widthDiv, 1.0F, 1.0F + scale);
        GlStateManager.func_179109_b(0.0F, 0.0F, -0.25F);
        blade_south.func_78785_a(size);
        GlStateManager.func_179121_F();
        
        GlStateManager.func_179121_F();
    }

    public void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) 
    {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }
}
