package mekanism.generators.client.model;

import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class ModelHeatGenerator extends ModelBase
{
	public static ResourceLocation OVERLAY_ON = MekanismUtils.getResource(ResourceType.RENDER, "HeatGenerator_OverlayOn.png");
	public static ResourceLocation OVERLAY_OFF = MekanismUtils.getResource(ResourceType.RENDER, "HeatGenerator_OverlayOff.png");
	
	ModelRenderer drum;
	ModelRenderer ring1;
	ModelRenderer ring2;
	ModelRenderer back;
	ModelRenderer bar1;
	ModelRenderer bar2;
	ModelRenderer plate;
	ModelRenderer fin8;
	ModelRenderer fin7;
	ModelRenderer fin1;
	ModelRenderer fin2;
	ModelRenderer fin3;
	ModelRenderer fin4;
	ModelRenderer fin5;
	ModelRenderer fin6;
	ModelRenderer base;

	public ModelHeatGenerator() 
	{
		field_78090_t = 128;
		field_78089_u = 64;

		drum = new ModelRenderer(this, 0, 22);
		drum.func_78789_a(0F, 0F, 0F, 16, 9, 9);
		drum.func_78793_a(-8F, 8.5F, -7.5F);
		drum.func_78787_b(128, 64);
		drum.field_78809_i = true;
		setRotation(drum, 0F, 0F, 0F);
		ring1 = new ModelRenderer(this, 88, 0);
		ring1.func_78789_a(0F, 0F, 0F, 2, 10, 10);
		ring1.func_78793_a(3F, 8F, -8F);
		ring1.func_78787_b(128, 64);
		ring1.field_78809_i = true;
		setRotation(ring1, 0F, 0F, 0F);
		ring2 = new ModelRenderer(this, 88, 0);
		ring2.func_78789_a(0F, 0F, 0F, 2, 10, 10);
		ring2.func_78793_a(-5F, 8F, -8F);
		ring2.func_78787_b(128, 64);
		ring2.field_78809_i = true;
		setRotation(ring2, 0F, 0F, 0F);
		back = new ModelRenderer(this, 48, 0);
		back.func_78789_a(0F, 0F, 0F, 16, 10, 4);
		back.func_78793_a(-8F, 8F, 2F);
		back.func_78787_b(128, 64);
		back.field_78809_i = true;
		setRotation(back, 0F, 0F, 0F);
		bar1 = new ModelRenderer(this, 88, 0);
		bar1.func_78789_a(0F, 0F, 0F, 2, 9, 1);
		bar1.func_78793_a(3F, 9F, 6F);
		bar1.func_78787_b(128, 64);
		bar1.field_78809_i = true;
		setRotation(bar1, 0F, 0F, 0F);
		bar2 = new ModelRenderer(this, 88, 0);
		bar2.func_78789_a(0F, 0F, 0F, 2, 9, 1);
		bar2.func_78793_a(-5F, 9F, 6F);
		bar2.func_78787_b(128, 64);
		bar2.field_78809_i = true;
		setRotation(bar2, 0F, 0F, 0F);
		plate = new ModelRenderer(this, 41, 22);
		plate.func_78789_a(0F, 0F, 0F, 8, 6, 2);
		plate.func_78793_a(-4F, 12F, 6F);
		plate.func_78787_b(128, 64);
		plate.field_78809_i = true;
		setRotation(plate, 0F, 0F, 0F);
		fin8 = new ModelRenderer(this, 14, 40);
		fin8.func_78789_a(0F, 0F, 0F, 16, 1, 2);
		fin8.func_78793_a(-8F, 8F, 6F);
		fin8.func_78787_b(128, 64);
		fin8.field_78809_i = true;
		setRotation(fin8, 0F, 0F, 0F);
		fin7 = new ModelRenderer(this, 14, 40);
		fin7.func_78789_a(0F, 0F, 0F, 16, 1, 2);
		fin7.func_78793_a(-8F, 10F, 6F);
		fin7.func_78787_b(128, 64);
		fin7.field_78809_i = true;
		setRotation(fin7, 0F, 0F, 0F);
		fin1 = new ModelRenderer(this, 0, 40);
		fin1.func_78789_a(0F, 0F, 0F, 4, 1, 2);
		fin1.func_78793_a(4F, 12F, 6F);
		fin1.func_78787_b(128, 64);
		fin1.field_78809_i = true;
		setRotation(fin1, 0F, 0F, 0F);
		fin1.field_78809_i = false;
		fin2 = new ModelRenderer(this, 0, 40);
		fin2.func_78789_a(0F, 0F, 0F, 4, 1, 2);
		fin2.func_78793_a(4F, 14F, 6F);
		fin2.func_78787_b(128, 64);
		fin2.field_78809_i = true;
		setRotation(fin2, 0F, 0F, 0F);
		fin2.field_78809_i = false;
		fin3 = new ModelRenderer(this, 0, 40);
		fin3.func_78789_a(0F, 0F, 0F, 4, 1, 2);
		fin3.func_78793_a(4F, 16F, 6F);
		fin3.func_78787_b(128, 64);
		fin3.field_78809_i = true;
		setRotation(fin3, 0F, 0F, 0F);
		fin3.field_78809_i = false;
		fin4 = new ModelRenderer(this, 0, 40);
		fin4.func_78789_a(0F, 0F, 0F, 4, 1, 2);
		fin4.func_78793_a(-8F, 12F, 6F);
		fin4.func_78787_b(128, 64);
		fin4.field_78809_i = true;
		setRotation(fin4, 0F, 0F, 0F);
		fin5 = new ModelRenderer(this, 0, 40);
		fin5.func_78789_a(0F, 0F, 0F, 4, 1, 2);
		fin5.func_78793_a(-8F, 14F, 6F);
		fin5.func_78787_b(128, 64);
		fin5.field_78809_i = true;
		setRotation(fin5, 0F, 0F, 0F);
		fin6 = new ModelRenderer(this, 0, 40);
		fin6.func_78789_a(0F, 0F, 0F, 4, 1, 2);
		fin6.func_78793_a(-8F, 16F, 6F);
		fin6.func_78787_b(128, 64);
		fin6.field_78809_i = true;
		setRotation(fin6, 0F, 0F, 0F);
		base = new ModelRenderer(this, 0, 0);
		base.func_78789_a(0F, 0F, 0F, 16, 6, 16);
		base.func_78793_a(-8F, 18F, -8F);
		base.func_78787_b(128, 64);
		base.field_78809_i = true;
		setRotation(base, 0F, 0F, 0F);
	}
	
	public void render(float size, boolean on, TextureManager manager)
	{
		GlStateManager.func_179094_E();
		MekanismRenderer.blendOn();
		
		doRender(size);
		
		manager.func_110577_a(on ? OVERLAY_ON : OVERLAY_OFF);
		GlStateManager.func_179152_a(1.001F, 1.001F, 1.001F);
		GlStateManager.func_179109_b(0, -0.0011F, 0);
		MekanismRenderer.glowOn();
		
		doRender(size);
		
		MekanismRenderer.glowOff();
		MekanismRenderer.blendOff();
		GlStateManager.func_179121_F();
	}

	private void doRender(float size) 
	{
		drum.func_78785_a(size);
		ring1.func_78785_a(size);
		ring2.func_78785_a(size);
		back.func_78785_a(size);
		bar1.func_78785_a(size);
		bar2.func_78785_a(size);
		plate.func_78785_a(size);
		fin8.func_78785_a(size);
		fin7.func_78785_a(size);
		fin1.func_78785_a(size);
		fin2.func_78785_a(size);
		fin3.func_78785_a(size);
		fin4.func_78785_a(size);
		fin5.func_78785_a(size);
		fin6.func_78785_a(size);
		base.func_78785_a(size);
	}

	private void setRotation(ModelRenderer model, float x, float y, float z)
	{
		model.field_78795_f = x;
		model.field_78796_g = y;
		model.field_78808_h = z;
	}
}
