package mekanism.generators.client.gui;

import java.util.List;

import mekanism.api.EnumColor;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.element.GuiElement.IInfoHandler;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.common.config.MekanismConfig.general;
import mekanism.common.config.MekanismConfig.generators;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.util.LangUtils;
import mekanism.common.util.ListUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import mekanism.generators.client.gui.element.GuiTurbineTab;
import mekanism.generators.client.gui.element.GuiTurbineTab.TurbineTab;
import mekanism.generators.common.content.turbine.TurbineUpdateProtocol;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class GuiTurbineStats extends GuiMekanism
{
	public TileEntityTurbineCasing tileEntity;

	public GuiTurbineStats(InventoryPlayer inventory, TileEntityTurbineCasing tentity)
	{
		super(tentity, new ContainerNull(inventory.field_70458_d, tentity));
		tileEntity = tentity;
		guiElements.add(new GuiTurbineTab(this, tileEntity, TurbineTab.MAIN, 6, MekanismUtils.getResource(ResourceType.GUI, "GuiNull.png")));
		guiElements.add(new GuiEnergyInfo(new IInfoHandler()
		{
			@Override
			public List<String> getInfo()
			{
				double energyMultiplier = (general.maxEnergyPerSteam/TurbineUpdateProtocol.MAX_BLADES)*Math.min(tileEntity.structure.blades, tileEntity.structure.coils*generators.turbineBladesPerCoil);
				
				return ListUtils.asList(
						LangUtils.localize("gui.storing") + ": " + MekanismUtils.getEnergyDisplay(tileEntity.getEnergy(), tileEntity.getMaxEnergy()),
						LangUtils.localize("gui.producing") + ": " + MekanismUtils.getEnergyDisplay(tileEntity.structure.clientFlow*energyMultiplier) + "/t");
			}
		}, this, MekanismUtils.getResource(ResourceType.GUI, "GuiNull.png")));
	}
	
	@Override
	protected void func_146979_b(int mouseX, int mouseY)
	{
		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		String stats = LangUtils.localize("gui.turbineStats");
		String limiting = EnumColor.DARK_RED + " (" + LangUtils.localize("gui.limiting") + ")";
		
		field_146289_q.func_78276_b(stats, (field_146999_f/2)-(field_146289_q.func_78256_a(stats)/2), 6, 0x404040);
		
		field_146289_q.func_78276_b(LangUtils.localize("gui.tankVolume") + ": " + tileEntity.structure.lowerVolume, 8, 26, 0x404040);
		
		boolean dispersersLimiting = tileEntity.structure.lowerVolume*tileEntity.structure.clientDispersers*generators.turbineDisperserGasFlow < 
				tileEntity.structure.vents*generators.turbineVentGasFlow;
		boolean ventsLimiting = tileEntity.structure.lowerVolume*tileEntity.structure.clientDispersers*generators.turbineDisperserGasFlow > 
				tileEntity.structure.vents*generators.turbineVentGasFlow;
		
		field_146289_q.func_78276_b(LangUtils.localize("gui.steamFlow"), 8, 40, 0x797979);
		field_146289_q.func_78276_b(LangUtils.localize("gui.dispersers") + ": " + tileEntity.structure.clientDispersers + (dispersersLimiting ? limiting : ""), 14, 49, 0x404040);
		field_146289_q.func_78276_b(LangUtils.localize("gui.vents") + ": " + tileEntity.structure.vents + (ventsLimiting ? limiting : ""), 14, 58, 0x404040);
		
		boolean bladesLimiting = tileEntity.structure.coils*4 > tileEntity.structure.blades;
		boolean coilsLimiting = tileEntity.structure.coils*4 < tileEntity.structure.blades;
		
		field_146289_q.func_78276_b(LangUtils.localize("gui.production"), 8, 72, 0x797979);
		field_146289_q.func_78276_b(LangUtils.localize("gui.blades") + ": " + tileEntity.structure.blades + (bladesLimiting ? limiting : ""), 14, 81, 0x404040);
		field_146289_q.func_78276_b(LangUtils.localize("gui.coils") + ": " + tileEntity.structure.coils + (coilsLimiting ? limiting : ""), 14, 90, 0x404040);
		
		double energyMultiplier = (general.maxEnergyPerSteam/TurbineUpdateProtocol.MAX_BLADES)*Math.min(tileEntity.structure.blades, tileEntity.structure.coils*generators.turbineBladesPerCoil);
		double rate = tileEntity.structure.lowerVolume*(tileEntity.structure.clientDispersers*generators.turbineDisperserGasFlow);		
		rate = Math.min(rate, tileEntity.structure.vents*generators.turbineVentGasFlow);
		
		field_146289_q.func_78276_b(LangUtils.localize("gui.maxProduction") + ": " + MekanismUtils.getEnergyDisplay(rate*energyMultiplier), 8, 104, 0x404040);
		field_146289_q.func_78276_b(LangUtils.localize("gui.maxWaterOutput") + ": " + tileEntity.structure.condensers*generators.condenserRate + " mB/t", 8, 113, 0x404040);
		
		super.func_146979_b(mouseX, mouseY);
	}
	
	@Override
	protected void func_146976_a(float partialTick, int mouseX, int mouseY)
	{
		field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.GUI, "GuiNull.png"));
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;
		func_73729_b(guiWidth, guiHeight, 0, 0, field_146999_f, field_147000_g);
		
		super.func_146976_a(partialTick, mouseX, mouseY);
	}
}
