package mekanism.generators.client.gui;

import java.io.IOException;
import java.util.ArrayList;

import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.network.PacketTileEntity.TileEntityMessage;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import mekanism.generators.common.tile.reactor.TileEntityReactorLogicAdapter;
import mekanism.generators.common.tile.reactor.TileEntityReactorLogicAdapter.ReactorLogic;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class GuiReactorLogicAdapter extends GuiMekanism
{
	public TileEntityReactorLogicAdapter tileEntity;
	
	public GuiReactorLogicAdapter(InventoryPlayer inventory, final TileEntityReactorLogicAdapter tentity)
	{
		super(new ContainerNull(inventory.field_70458_d, tentity));
		
		tileEntity = tentity;
	}
	
	@Override
	protected void func_146979_b(int mouseX, int mouseY)
	{
		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);
		
		field_146289_q.func_78276_b(tileEntity.func_70005_c_(), (field_146999_f/2)-(field_146289_q.func_78256_a(tileEntity.func_70005_c_())/2), 6, 0x404040);
		renderScaledText(LangUtils.localize("gui.coolingMeasurements") + ": " + EnumColor.RED + LangUtils.transOnOff(tileEntity.activeCooled), 36, 20, 0x404040, 117);
		renderScaledText(LangUtils.localize("gui.redstoneOutputMode") + ": " + EnumColor.RED + tileEntity.logicType.getLocalizedName(), 23, 123, 0x404040, 130);
		
		String text = LangUtils.localize("gui.status") + ": " + EnumColor.RED + LangUtils.localize("gui." + (tileEntity.checkMode() ? "outputting" : "idle"));
		field_146289_q.func_78276_b(text, (field_146999_f/2)-(field_146289_q.func_78256_a(text)/2), 136, 0x404040); 
		
		for(ReactorLogic type : ReactorLogic.values())
		{
			GlStateManager.func_179094_E();
			RenderHelper.func_74520_c();
			field_146296_j.func_180450_b(type.getRenderStack(), 27, 35 + (22*type.ordinal()));
			RenderHelper.func_74518_a();
			GlStateManager.func_179121_F();
			
			field_146289_q.func_78276_b(EnumColor.WHITE + type.getLocalizedName(), 46, 34+(22*type.ordinal()), 0x404040);
		}
		
		for(ReactorLogic type : ReactorLogic.values())
		{
			if(xAxis >= 24 && xAxis <= 152 && yAxis >= 32+(22*type.ordinal()) && yAxis <= 32+22+(22*type.ordinal()))
			{
				displayTooltips(MekanismUtils.splitTooltip(type.getDescription(), ItemStack.field_190927_a), xAxis, yAxis);
			}
		}
		
		if(xAxis >= 23 && xAxis <= 34 && yAxis >= 19 && yAxis <= 30)
		{
			func_146279_a(LangUtils.localize("gui.toggleCooling"), xAxis, yAxis);
		}
		
		super.func_146979_b(mouseX, mouseY);
	}

	@Override
	protected void func_146976_a(float partialTick, int mouseX, int mouseY)
	{
		field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.GUI, "GuiReactorLogicAdapter.png"));
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;
		func_73729_b(guiWidth, guiHeight, 0, 0, field_146999_f, field_147000_g);
		
		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);
		
		for(ReactorLogic type : ReactorLogic.values())
		{
			MekanismRenderer.color(EnumColor.RED);
			
			func_73729_b(guiWidth + 24, guiHeight + 32+(22*type.ordinal()), 0, 166+(type == tileEntity.logicType ? 22 : 0), 128, 22);
			
			MekanismRenderer.resetColor();
		}
		
		if(xAxis >= 23 && xAxis <= 34 && yAxis >= 19 && yAxis <= 30)
		{
			func_73729_b(guiWidth + 23, guiHeight + 19, 176, 0, 11, 11);
		}
		else {
			func_73729_b(guiWidth + 23, guiHeight + 19, 176, 11, 11, 11);
		}

		super.func_146976_a(partialTick, mouseX, mouseY);
	}
	
	@Override
	protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException
	{
		super.func_73864_a(mouseX, mouseY, button);
		
		if(button == 0)
		{
			int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
			int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);
			
			if(xAxis >= 23 && xAxis <= 34 && yAxis >= 19 && yAxis <= 30)
			{
				SoundHandler.playSound(SoundEvents.field_187909_gi);
				
				ArrayList data = new ArrayList();
				data.add(0);
				
				Mekanism.packetHandler.sendToServer(new TileEntityMessage(Coord4D.get(tileEntity), data));
				
				return;
			}
			
			for(ReactorLogic type : ReactorLogic.values())
			{
				if(xAxis >= 24 && xAxis <= 152 && yAxis >= 32+(22*type.ordinal()) && yAxis <= 32+22+(22*type.ordinal()))
				{
					if(type != tileEntity.logicType)
					{
						SoundHandler.playSound(SoundEvents.field_187909_gi);
						
						ArrayList data = new ArrayList();
						data.add(1);
						data.add(type.ordinal());
						
						Mekanism.packetHandler.sendToServer(new TileEntityMessage(Coord4D.get(tileEntity), data));
						
						return;
					}
				}
			}
		}
	}
}
