package mekanism.common.world;

import java.util.Random;

import mekanism.common.MekanismBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenSalt extends WorldGenerator
{
    private Block blockGen;
    
    private int numberOfBlocks;

    public WorldGenSalt(int blockNum)
    {
        blockGen = MekanismBlocks.SaltBlock;
        numberOfBlocks = blockNum;
    }

    @Override
    public boolean func_180709_b(World world, Random random, BlockPos pos)
    {
        if(world.func_180495_p(pos).func_185904_a() != Material.field_151586_h)
        {
            return false;
        }
        else {
            int toGenerate = random.nextInt(numberOfBlocks - 2) + 2;
            byte yOffset = 1;

            for(int xPos = pos.func_177958_n() - toGenerate; xPos <= pos.func_177958_n() + toGenerate; xPos++)
            {
                for(int zPos = pos.func_177952_p() - toGenerate; zPos <= pos.func_177952_p() + toGenerate; zPos++)
                {
                    int xOffset = xPos - pos.func_177958_n();
                    int zOffset = zPos - pos.func_177952_p();

                    if((xOffset*xOffset) + (zOffset*zOffset) <= toGenerate*toGenerate)
                    {
                        for(int yPos = pos.func_177956_o() - yOffset; yPos <= pos.func_177956_o() + yOffset; yPos++)
                        {
                            BlockPos newPos = new BlockPos(xPos, yPos, zPos);
                            Block block = world.func_180495_p(newPos).func_177230_c();

                            if(block == Blocks.field_150346_d || block == Blocks.field_150435_aG || block == MekanismBlocks.SaltBlock)
                            {
                                world.func_180501_a(newPos, blockGen.func_176223_P(), 2);
                            }
                        }
                    }
                }
            }

            return true;
        }
    }
}
