package mekanism.common.world;

import java.util.Random;

import mekanism.common.MekanismBlocks;
import mekanism.common.config.MekanismConfig.general;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderEnd;
import net.minecraft.world.gen.ChunkProviderHell;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class GenHandler implements IWorldGenerator
{
	@Override
	public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider)
	{
		if(!(chunkGenerator instanceof ChunkProviderHell) && !(chunkGenerator instanceof ChunkProviderEnd))
		{
			for(int i = 0; i < general.osmiumPerChunk; i++)
			{
				BlockPos pos = new BlockPos(chunkX*16 + random.nextInt(16), random.nextInt(60), (chunkZ*16) + random.nextInt(16));
				new WorldGenMinable(MekanismBlocks.OreBlock.func_176203_a(0), 8, BlockMatcher.func_177642_a(Blocks.field_150348_b)).func_180709_b(world, random, pos);
			}

			for(int i = 0; i < general.copperPerChunk; i++)
			{
				BlockPos pos = new BlockPos(chunkX*16 + random.nextInt(16), random.nextInt(60), (chunkZ*16) + random.nextInt(16));
				new WorldGenMinable(MekanismBlocks.OreBlock.func_176203_a(1), 8, BlockMatcher.func_177642_a(Blocks.field_150348_b)).func_180709_b(world, random, pos);
			}

			for(int i = 0; i < general.tinPerChunk; i++)
			{
				BlockPos pos = new BlockPos(chunkX*16 + random.nextInt(16), random.nextInt(60), (chunkZ*16) + random.nextInt(16));
				new WorldGenMinable(MekanismBlocks.OreBlock.func_176203_a(2), 8, BlockMatcher.func_177642_a(Blocks.field_150348_b)).func_180709_b(world, random, pos);
			}
			
			for(int i = 0; i < general.saltPerChunk; i++)
			{
				int randPosX = (chunkX*16) + random.nextInt(16) + 8;
				int randPosZ = (chunkZ*16) + random.nextInt(16) + 8;
				BlockPos pos = world.func_175672_r(new BlockPos(randPosX, 60, randPosZ));
				new WorldGenSalt(6).func_180709_b(world, random, pos);
			}
		}
	}
}
