package mekanism.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import mekanism.api.energy.IEnergizedItem;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasItem;
import mekanism.common.Upgrade;
import mekanism.common.base.IFactory;
import mekanism.common.base.ITierItem;
import mekanism.common.block.states.BlockStateBasic.BasicBlockType;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.inventory.InventoryBin;
import mekanism.common.recipe.ShapedMekanismRecipe;
import mekanism.common.recipe.ShapelessMekanismRecipe;
import mekanism.common.security.ISecurityItem;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.oredict.OreDictionary;

public class RecipeUtils 
{
	public static boolean areItemsEqualForCrafting(ItemStack target, ItemStack input)
	{
		if(target.func_190926_b() && !input.func_190926_b() || !target.func_190926_b() && input.func_190926_b())
		{
			return false;
		}
		else if(target.func_190926_b() && input.func_190926_b())
		{
			return true;
		}

		if(target.func_77973_b() != input.func_77973_b())
		{
			return false;
		}
		
		if(target.func_77952_i() != input.func_77952_i() && target.func_77952_i() != OreDictionary.WILDCARD_VALUE)
		{
			return false;
		}
		
		if(target.func_77973_b() instanceof ITierItem && input.func_77973_b() instanceof ITierItem)
		{
			if(((ITierItem)target.func_77973_b()).getBaseTier(target) != ((ITierItem)input.func_77973_b()).getBaseTier(input))
			{
				return false;
			}
		}
		
		if(target.func_77973_b() instanceof IFactory && input.func_77973_b() instanceof IFactory)
		{
			if(isFactory(target) && isFactory(input))
			{
				if(((IFactory)target.func_77973_b()).getRecipeType(target) != ((IFactory)input.func_77973_b()).getRecipeType(input))
				{
					return false;
				}
			}
		}

		return true;
	}
	
	private static boolean isFactory(ItemStack stack)
	{
		return BlockStateMachine.MachineType.get(stack) == BlockStateMachine.MachineType.BASIC_FACTORY || BlockStateMachine.MachineType.get(stack) == BlockStateMachine.MachineType.ADVANCED_FACTORY || BlockStateMachine.MachineType.get(stack) == BlockStateMachine.MachineType.ELITE_FACTORY;
	}
	
	public static ItemStack getCraftingResult(InventoryCrafting inv, ItemStack toReturn)
	{
		if(toReturn.func_77973_b() instanceof IEnergizedItem)
		{
			double energyFound = 0;

			for(int i = 0; i < 9; i++)
			{
				ItemStack itemstack = inv.func_70301_a(i);

				if(!itemstack.func_190926_b() && itemstack.func_77973_b() instanceof IEnergizedItem)
				{
					energyFound += ((IEnergizedItem)itemstack.func_77973_b()).getEnergy(itemstack);
				}
			}

			((IEnergizedItem)toReturn.func_77973_b()).setEnergy(toReturn, Math.min(((IEnergizedItem)toReturn.func_77973_b()).getMaxEnergy(toReturn), energyFound));
		}
		
		if(toReturn.func_77973_b() instanceof IGasItem)
		{
			GasStack gasFound = null;
			
			for(int i = 0; i < 9; i++)
			{
				ItemStack itemstack = inv.func_70301_a(i);

				if(!itemstack.func_190926_b() && itemstack.func_77973_b() instanceof IGasItem)
				{
					GasStack stored = ((IGasItem)itemstack.func_77973_b()).getGas(itemstack);
					
					if(stored != null)
					{
						if(!((IGasItem)toReturn.func_77973_b()).canReceiveGas(toReturn, stored.getGas()))
						{
							return ItemStack.field_190927_a;
						}
						
						if(gasFound == null)
						{
							gasFound = stored;
						}
						else {
							if(gasFound.getGas() != stored.getGas())
							{
								return ItemStack.field_190927_a;
							}
							
							gasFound.amount += stored.amount;
						}
					}
				}
			}
			
			if(gasFound != null)
			{
				gasFound.amount = Math.min(((IGasItem)toReturn.func_77973_b()).getMaxGas(toReturn), gasFound.amount);
				((IGasItem)toReturn.func_77973_b()).setGas(toReturn, gasFound);
			}
		}
		
		if(toReturn.func_77973_b() instanceof ISecurityItem)
		{
			for(int i = 0; i < 9; i++)
			{
				ItemStack itemstack = inv.func_70301_a(i);
				
				if(!itemstack.func_190926_b() && itemstack.func_77973_b() instanceof ISecurityItem)
				{
					((ISecurityItem)toReturn.func_77973_b()).setOwnerUUID(toReturn, ((ISecurityItem)itemstack.func_77973_b()).getOwnerUUID(itemstack));
					((ISecurityItem)toReturn.func_77973_b()).setSecurity(toReturn, ((ISecurityItem)itemstack.func_77973_b()).getSecurity(itemstack));
					
					break;
				}
			}
		}
		
		if(FluidContainerUtils.isFluidContainer(toReturn))
		{
			FluidStack fluidFound = null;
			
			for(int i = 0; i < 9; i++)
			{
				ItemStack itemstack = inv.func_70301_a(i);

				if(FluidContainerUtils.isFluidContainer(itemstack))
				{
					FluidStack stored = FluidUtil.getFluidContained(itemstack);
					
					if(stored != null)
					{
						if(FluidUtil.getFluidHandler(itemstack).fill(stored, false) == 0)
						{
							return ItemStack.field_190927_a;
						}
						
						if(fluidFound == null)
						{
							fluidFound = stored;
						}
						else {
							if(fluidFound.getFluid() != stored.getFluid())
							{
								return ItemStack.field_190927_a;
							}
							
							fluidFound.amount += stored.amount;
						}
					}
				}
			}
			
			if(fluidFound != null)
			{
				FluidUtil.getFluidHandler(toReturn).fill(fluidFound, true);
			}
		}
		
		if(BasicBlockType.get(toReturn) == BasicBlockType.BIN)
		{
			int foundCount = 0;
			ItemStack foundType = ItemStack.field_190927_a;
			
			for(int i = 0; i < 9; i++)
			{
				ItemStack itemstack = inv.func_70301_a(i);

				if(!itemstack.func_190926_b() && BasicBlockType.get(itemstack) == BasicBlockType.BIN)
				{
					InventoryBin binInv = new InventoryBin(itemstack);
					
					foundCount = binInv.getItemCount();
					foundType = binInv.getItemType();
				}
			}
			
			if(foundCount > 0 && !foundType.func_190926_b())
			{
				InventoryBin binInv = new InventoryBin(toReturn);
				binInv.setItemCount(foundCount);
				binInv.setItemType(foundType);
			}
		}

		if(BlockStateMachine.MachineType.get(toReturn) != null && BlockStateMachine.MachineType.get(toReturn).supportsUpgrades)
		{
			Map<Upgrade, Integer> upgrades = new HashMap<Upgrade, Integer>();

			for(int i = 0; i < 9; i++)
			{
				ItemStack itemstack = inv.func_70301_a(i);

				if(!itemstack.func_190926_b() && BlockStateMachine.MachineType.get(itemstack) != null && BlockStateMachine.MachineType.get(itemstack).supportsUpgrades)
				{
					Map<Upgrade, Integer> stackMap = Upgrade.buildMap(ItemDataUtils.getDataMap(itemstack));
					
					for(Map.Entry<Upgrade, Integer> entry : stackMap.entrySet())
					{
						if(entry != null && entry.getKey() != null && entry.getValue() != null)
						{
							Integer val = upgrades.get(entry.getKey());
							
							upgrades.put(entry.getKey(), Math.min(entry.getKey().getMax(), (val != null ? val : 0) + entry.getValue()));
						}
					}
				}
			}
			
			Upgrade.saveMap(upgrades, ItemDataUtils.getDataMap(toReturn));
		}

		return toReturn;
	}
	
	public static ItemStack loadRecipeItemStack(NBTTagCompound nbtTags)
	{
		int meta = 0;
		int amount = 1;
		
		if(nbtTags.func_74764_b("meta"))
		{
			meta = nbtTags.func_74762_e("meta");
		}
		
		if(nbtTags.func_74764_b("amount"))
		{
			amount = nbtTags.func_74762_e("amount");
		}
		
		if(nbtTags.func_74764_b("itemstack"))
		{
			return InventoryUtils.loadFromNBT(nbtTags.func_74775_l("itemstack"));
		}
		else if(nbtTags.func_74764_b("itemname"))
		{
			Object obj = Item.field_150901_e.func_82594_a(new ResourceLocation(nbtTags.func_74779_i("itemname")));
			
			if(obj != null)
			{
				return new ItemStack((Item)obj, amount, meta);
			}
		}
		else if(nbtTags.func_74764_b("blockname"))
		{
			Object obj = Block.field_149771_c.func_82594_a(new ResourceLocation(nbtTags.func_74779_i("blockname")));
			
			if(obj != null)
			{
				return new ItemStack((Block)obj, amount, meta);
			}
		}
		
		return ItemStack.field_190927_a;
	}
	
	public static boolean removeRecipes(ItemStack stack)
	{
		List<IRecipe> recipes = CraftingManager.func_77594_a().func_77592_b();
		
		for(Iterator<IRecipe> iter = recipes.iterator(); iter.hasNext();)
		{
			IRecipe iterRecipe = iter.next();
			
			if(iterRecipe instanceof ShapedMekanismRecipe || iterRecipe instanceof ShapelessMekanismRecipe)
			{
				if(StackUtils.equalsWildcard(stack, iterRecipe.func_77571_b()))
				{
					iter.remove();
				}
			}
		}
		
		return false;
	}
	
	public static IRecipe getRecipeFromGrid(InventoryCrafting inv, World world)
	{
		List<IRecipe> list = new ArrayList<IRecipe>(CraftingManager.func_77594_a().func_77592_b());
		
		for(Iterator<IRecipe> iter = list.iterator(); iter.hasNext();)
		{
			IRecipe recipe = iter.next();
			
			if(recipe.func_77569_a(inv, world))
			{
				return recipe;
			}
		}
		
		return null;
	}
}
