package mekanism.common.util;

import java.util.Collection;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

import org.apache.commons.lang3.tuple.Pair;

public final class MultipartUtils 
{
	public static AxisAlignedBB rotate(AxisAlignedBB aabb, EnumFacing side) 
	{
        Vec3d v1 = rotate(new Vec3d(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c), side);
        Vec3d v2 = rotate(new Vec3d(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f), side);
        
        return new AxisAlignedBB(v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c);
    }

    public static Vec3d rotate(Vec3d vec, EnumFacing side)
    {
        switch(side) 
        {
	        case DOWN:
	            return new Vec3d(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
	        case UP:
	            return new Vec3d(vec.field_72450_a, -vec.field_72448_b, -vec.field_72449_c);
	        case NORTH:
	            return new Vec3d(vec.field_72450_a, -vec.field_72449_c, vec.field_72448_b);
	        case SOUTH:
	            return new Vec3d(vec.field_72450_a, vec.field_72449_c, -vec.field_72448_b);
	        case WEST:
	            return new Vec3d(vec.field_72448_b, -vec.field_72450_a, vec.field_72449_c);
	        case EAST:
	            return new Vec3d(-vec.field_72448_b, vec.field_72450_a, vec.field_72449_c);
        }
        
        return null;
    }
    
    /* taken from MCMP */
    public static Pair<Vec3d, Vec3d> getRayTraceVectors(EntityPlayer player) 
    {
        float pitch = player.field_70125_A;
        float yaw = player.field_70177_z;
        Vec3d start = new Vec3d(player.field_70165_t, player.field_70163_u + player.func_70047_e(), player.field_70161_v);
        float f1 = MathHelper.func_76134_b(-yaw * 0.017453292F - (float) Math.PI);
        float f2 = MathHelper.func_76126_a(-yaw * 0.017453292F - (float) Math.PI);
        float f3 = -MathHelper.func_76134_b(-pitch * 0.017453292F);
        float f4 = MathHelper.func_76126_a(-pitch * 0.017453292F);
        float f5 = f2 * f3;
        float f6 = f1 * f3;
        double d3 = 5.0D;
        
        if(player instanceof EntityPlayerMP) 
        {
            d3 = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        }
        
        Vec3d end = start.func_72441_c(f5 * d3, f4 * d3, f6 * d3);
        return Pair.of(start, end);
    }
    
    public static AdvancedRayTraceResult collisionRayTrace(BlockPos pos, Vec3d start, Vec3d end, Collection<AxisAlignedBB> boxes)
    {
        double minDistance = Double.POSITIVE_INFINITY;
        AdvancedRayTraceResult hit = null;
        int i = -1;

        for(AxisAlignedBB aabb : boxes) 
        {
            AdvancedRayTraceResult result = aabb == null ? null : collisionRayTrace(pos, start, end, aabb, i, null);

            if(result != null)
            {
                double d = result.squareDistanceTo(start);
                
                if(d < minDistance) 
                {
                    minDistance = d;
                    hit = result;
                }
            }

            i++;
        }

        return hit;
    }
    
    public static AdvancedRayTraceResult collisionRayTrace(BlockPos pos, Vec3d start, Vec3d end, AxisAlignedBB bounds, int subHit, Object hitInfo)
    {
        RayTraceResult result = bounds.func_186670_a(pos).func_72327_a(start, end);

        if(result == null) 
        {
            return null;
        }

        result = new RayTraceResult(RayTraceResult.Type.BLOCK, result.field_72307_f, result.field_178784_b, pos);
        result.subHit = subHit;
        result.hitInfo = hitInfo;

        return new AdvancedRayTraceResult(result, bounds);
    }
    
    private static class AdvancedRayTraceResultBase<T extends RayTraceResult> 
    {
        public final AxisAlignedBB bounds;
        public final T hit;

        public AdvancedRayTraceResultBase(T mop, AxisAlignedBB aabb)
        {
            hit = mop;
            bounds = aabb;
        }

        public boolean valid()
        {
            return hit != null && bounds != null;
        }

        public double squareDistanceTo(Vec3d vec) 
        {
            return hit.field_72307_f.func_72436_e(vec);
        }
    }

    public static class AdvancedRayTraceResult extends AdvancedRayTraceResultBase<RayTraceResult> 
    {
        public AdvancedRayTraceResult(RayTraceResult mop, AxisAlignedBB bounds) 
        {
            super(mop, bounds);
        }
    }
}
