package mekanism.common.tile.transmitter;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;

import mekanism.api.Coord4D;
import mekanism.api.IAlloyInteraction;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.DynamicNetwork.NetworkClientRequest;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.TransmitterNetworkRegistry;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.transmitters.TransmitterImpl;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;

import mekanism.common.tile.transmitter.TileEntitySidedPipe.ConnectionType;

public abstract class TileEntityTransmitter<A, N extends DynamicNetwork<A, N>> extends TileEntitySidedPipe implements IAlloyInteraction
{
	public TransmitterImpl<A, N> transmitterDelegate;

	public boolean unloaded = true;
	
	public boolean dataRequest = false;
	
	private N lastClientNetwork = null;

	public TileEntityTransmitter()
	{
		transmitterDelegate = new TransmitterImpl<>(this);
	}

	public TransmitterImpl<A, N> getTransmitter()
	{
		return transmitterDelegate;
	}

	public abstract N createNewNetwork();

	public abstract N createNetworkByMerging(Collection<N> networks);

	@Override
	public void onWorldJoin()
	{
		if(!func_145831_w().field_72995_K)
		{
			TransmitterNetworkRegistry.registerOrphanTransmitter(getTransmitter());
		}
		else if(lastClientNetwork != null)
		{
			getTransmitter().setTransmitterNetwork(lastClientNetwork);
		}

		unloaded = false;
	}
	
	@Override
	public void func_73660_a()
	{
		super.func_73660_a();
		
		if(func_145831_w().field_72995_K)
		{
			if(!dataRequest)
			{
				dataRequest = true;
				MinecraftForge.EVENT_BUS.post(new NetworkClientRequest(func_145831_w().func_175625_s(func_174877_v())));
			}
		}
	}
	
	@Override
	public void onChunkUnload()
	{
		if(!func_145831_w().field_72995_K)
		{
			getTransmitter().takeShare();
		}
		
		super.onChunkUnload();
	}
	
	@Override
	public void onWorldSeparate() 
	{
		unloaded = true;
		
		if(!func_145831_w().field_72995_K)
		{
			TransmitterNetworkRegistry.invalidateTransmitter(getTransmitter());
		}
		else {
			lastClientNetwork = getTransmitter().getTransmitterNetwork();
			getTransmitter().setTransmitterNetwork(null);
		}
	}

	@Override
	public void markDirtyTransmitters()
	{
		super.markDirtyTransmitters();
		
		if(getTransmitter().hasTransmitterNetwork())
		{
			TransmitterNetworkRegistry.invalidateTransmitter(getTransmitter());
		}
	}

	@Override
	public void markDirtyAcceptor(EnumFacing side)
	{
		super.markDirtyAcceptor(side);
		
		if(getTransmitter().hasTransmitterNetwork())
		{
			getTransmitter().getTransmitterNetwork().acceptorChanged(getTransmitter(), side);
		}
	}

	public abstract A getCachedAcceptor(EnumFacing side);
	
	protected TileEntity getCachedTile(EnumFacing side)
	{
		ConnectionType type = connectionTypes[side.ordinal()];
		
		if(type == ConnectionType.PULL || type == ConnectionType.NONE)
		{
			return null;
		}
		
		return connectionMapContainsSide(currentAcceptorConnections, side) ? cachedAcceptors[side.ordinal()] : null;
	}
	
	@Override
	public void onAlloyInteraction(EntityPlayer player, EnumHand hand, ItemStack stack, int tierOrdinal) 
	{
		if(getTransmitter().hasTransmitterNetwork())
		{
			int upgraded = 0;
			Object[] array = ((LinkedHashSet)getTransmitter().getTransmitterNetwork().transmitters.clone()).toArray();
			
			Arrays.sort(array, new Comparator() {
				@Override
				public int compare(Object o1, Object o2) 
				{
					if(o1 instanceof IGridTransmitter && o2 instanceof IGridTransmitter)
					{
						Coord4D thisCoord = new Coord4D(func_174877_v(), func_145831_w());
						
						Coord4D o1Coord = ((IGridTransmitter)o1).coord();
						Coord4D o2Coord = ((IGridTransmitter)o2).coord();
						
						return o1Coord.distanceTo(thisCoord) > o2Coord.distanceTo(thisCoord) ? 1 : 
							(o1Coord.distanceTo(thisCoord) < o2Coord.distanceTo(thisCoord) ? -1 : 0);
					}
					
					return 0;
				}
			});
			
			for(Object iter : array)
			{
				if(iter instanceof TransmitterImpl)
				{
					TileEntityTransmitter t = ((TransmitterImpl)iter).containingTile;
					
					if(t.upgrade(tierOrdinal))
					{
						upgraded++;
						
						if(upgraded == 8)
						{
							break;
						}
					}
				}
			}
			
			if(upgraded > 0)
			{
				if(!player.field_71075_bZ.field_75098_d)
				{
					stack.func_190918_g(1);
					
					if(stack.func_190916_E() == 0)
					{
						player.func_184611_a(hand, ItemStack.field_190927_a);
					}
				}
			}
		}
	}
	
	public boolean upgrade(int tierOrdinal)
	{
		return false;
	}

	public abstract int getCapacity();

	public abstract Object getBuffer();

	public abstract void takeShare();

    public abstract void updateShare();

	@Override
	public boolean hasCapability(Capability<?> capability, EnumFacing side)
	{
		return capability == Capabilities.GRID_TRANSMITTER_CAPABILITY || capability == Capabilities.ALLOY_INTERACTION_CAPABILITY 
				|| super.hasCapability(capability, side);
	}

	@Override
	public <T> T getCapability(Capability<T> capability, EnumFacing side)
	{
		if(capability == Capabilities.GRID_TRANSMITTER_CAPABILITY)
		{
			return (T)getTransmitter();
		}
		else if(capability == Capabilities.ALLOY_INTERACTION_CAPABILITY)
		{
			return (T)this;
		}
		
		return super.getCapability(capability, side);
	}
}
