package mekanism.common.tile.prefab;

import io.netty.buffer.ByteBuf;

import java.util.ArrayList;

import mekanism.common.Upgrade;
import mekanism.common.util.MekanismUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityOperationalMachine extends TileEntityMachine
{
	public int operatingTicks;

	public int BASE_TICKS_REQUIRED;

	public int ticksRequired;
	
	public TileEntityOperationalMachine(String sound, String name, double maxEnergy, double baseEnergyUsage, int upgradeSlot, int baseTicksRequired)
	{
		super(sound, name, maxEnergy, baseEnergyUsage, upgradeSlot);
		
		ticksRequired = BASE_TICKS_REQUIRED = baseTicksRequired;
	}
	
	public double getScaledProgress()
	{
		return ((double)operatingTicks) / (double)ticksRequired;
	}
	
	@Override
	public void handlePacketData(ByteBuf dataStream)
	{
		super.handlePacketData(dataStream);

		if(FMLCommonHandler.instance().getEffectiveSide().isClient())
		{
			operatingTicks = dataStream.readInt();
			ticksRequired = dataStream.readInt();
		}
	}

	@Override
	public ArrayList<Object> getNetworkedData(ArrayList<Object> data)
	{
		super.getNetworkedData(data);

		data.add(operatingTicks);
		data.add(ticksRequired);

		return data;
	}

	@Override
	public void func_145839_a(NBTTagCompound nbtTags)
	{
		super.func_145839_a(nbtTags);

		operatingTicks = nbtTags.func_74762_e("operatingTicks");
	}

	@Override
	public NBTTagCompound func_189515_b(NBTTagCompound nbtTags)
	{
		super.func_189515_b(nbtTags);

		nbtTags.func_74768_a("operatingTicks", operatingTicks);
		
		return nbtTags;
	}
	
	@Override
	public void recalculateUpgradables(Upgrade upgrade)
	{
		super.recalculateUpgradables(upgrade);

		switch(upgrade)
		{
			case SPEED:
				ticksRequired = MekanismUtils.getTicks(this, BASE_TICKS_REQUIRED);
				energyPerTick = MekanismUtils.getEnergyPerTick(this, BASE_ENERGY_PER_TICK);
				break;
			default:
				break;
		}
	}
}
