package mekanism.common.tile.prefab;

import mekanism.common.Upgrade;
import mekanism.common.base.ISustainedInventory;
import mekanism.common.base.ItemHandlerWrapper;
import mekanism.common.capabilities.CapabilityWrapperManager;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.LangUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.Constants.NBT;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class TileEntityContainerBlock extends TileEntityBasicBlock implements ISidedInventory, ISustainedInventory, ITickable
{
	/** The inventory slot itemstacks used by this block. */
	public NonNullList<ItemStack> inventory;

	/** The full name of this machine. */
	public String fullName;

	/**
	 * A simple tile entity with a container and facing state.
	 * @param name - full name of this tile entity
	 */
	public TileEntityContainerBlock(String name)
	{
		fullName = name;
	}
	
	@Override
	public boolean func_191420_l()
	{
		for(ItemStack stack : getInventory())
		{
			if(!stack.func_190926_b())
			{
				return false;
			}
		}
		
		return true;
	}

	@Override
	public void func_145839_a(NBTTagCompound nbtTags)
	{
		super.func_145839_a(nbtTags);

		if(handleInventory())
		{
			NBTTagList tagList = nbtTags.func_150295_c("Items", NBT.TAG_COMPOUND);
			inventory = NonNullList.func_191197_a(func_70302_i_(), ItemStack.field_190927_a);

			for(int tagCount = 0; tagCount < tagList.func_74745_c(); tagCount++)
			{
				NBTTagCompound tagCompound = tagList.func_150305_b(tagCount);
				byte slotID = tagCompound.func_74771_c("Slot");

				if(slotID >= 0 && slotID < func_70302_i_())
				{
					func_70299_a(slotID, InventoryUtils.loadFromNBT(tagCompound));
				}
			}
		}
	}

	@Override
	public NBTTagCompound func_189515_b(NBTTagCompound nbtTags)
	{
		super.func_189515_b(nbtTags);

		if(handleInventory())
		{
			NBTTagList tagList = new NBTTagList();

			for(int slotCount = 0; slotCount < func_70302_i_(); slotCount++)
			{
				ItemStack stackInSlot = func_70301_a(slotCount);
				if(!stackInSlot.func_190926_b())
				{
					NBTTagCompound tagCompound = new NBTTagCompound();
					tagCompound.func_74774_a("Slot", (byte)slotCount);
					stackInSlot.func_77955_b(tagCompound);
					tagList.func_74742_a(tagCompound);
				}
			}

			nbtTags.func_74782_a("Items", tagList);
		}
		
		return nbtTags;
	}
	
	protected NonNullList<ItemStack> getInventory()
	{
		return inventory;
	}

	@Override
	public int func_70302_i_()
	{
		return getInventory() != null ? getInventory().size() : 0;
	}

	@Override
	public ItemStack func_70301_a(int slotID)
	{
		return getInventory() != null ? getInventory().get(slotID) : ItemStack.field_190927_a;
	}

	@Override
	public ItemStack func_70298_a(int slotID, int amount)
	{
		if(getInventory() == null)
		{
			return ItemStack.field_190927_a;
		}
		
		return ItemStackHelper.func_188382_a(getInventory(), slotID, amount);
	}

	@Override
	public ItemStack func_70304_b(int slotID)
	{
		if(getInventory() == null)
		{
			return ItemStack.field_190927_a;
		}
		
		return ItemStackHelper.func_188383_a(getInventory(), slotID);
	}

	@Override
	public void func_70299_a(int slotID, ItemStack itemstack)
	{
		getInventory().set(slotID, itemstack);

		if(!itemstack.func_190926_b() && itemstack.func_190916_E() > func_70297_j_())
		{
			itemstack.func_190920_e(func_70297_j_());
		}
		
		func_70296_d();
	}

	@Override
	public boolean func_70300_a(EntityPlayer entityplayer)
	{
		return !func_145837_r();
	}

	@Override
	public String func_70005_c_()
	{
		return LangUtils.localize(func_145838_q().func_149739_a() + "." + fullName + ".name");
	}

	@Override
	public int func_70297_j_()
	{
		return 64;
	}

	@Override
	public void func_174889_b(EntityPlayer player) {}

	@Override
	public void func_174886_c(EntityPlayer player) {}

	@Override
	public boolean func_145818_k_()
	{
		return true;
	}

	@Override
	public boolean func_94041_b(int slotID, ItemStack itemstack)
	{
		return true;
	}

	@Override
	public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing side)
	{
		return func_94041_b(slotID, itemstack);
	}

	@Override
	public int[] func_180463_a(EnumFacing side)
	{
		return InventoryUtils.EMPTY;
	}

	@Override
	public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side)
	{
		return true;
	}

	@Override
	public void setInventory(NBTTagList nbtTags, Object... data)
	{
		if(nbtTags == null || nbtTags.func_74745_c() == 0 || !handleInventory())
		{
			return;
		}

		inventory = NonNullList.func_191197_a(func_70302_i_(), ItemStack.field_190927_a);
		
		for(int slots = 0; slots < nbtTags.func_74745_c(); slots++)
		{
			NBTTagCompound tagCompound = (NBTTagCompound)nbtTags.func_150305_b(slots);
			byte slotID = tagCompound.func_74771_c("Slot");

			if(slotID >= 0 && slotID < inventory.size())
			{
				inventory.set(slotID, InventoryUtils.loadFromNBT(tagCompound));
			}
		}
	}

	@Override
	public NBTTagList getInventory(Object... data)
	{
		NBTTagList tagList = new NBTTagList();

		if(handleInventory())
		{
			for(int slots = 0; slots < inventory.size(); slots++)
			{
				if(!inventory.get(slots).func_190926_b())
				{
					NBTTagCompound tagCompound = new NBTTagCompound();
					tagCompound.func_74774_a("Slot", (byte)slots);
					inventory.get(slots).func_77955_b(tagCompound);
					tagList.func_74742_a(tagCompound);
				}
			}
		}

		return tagList;
	}

	public boolean handleInventory()
	{
		return true;
	}

	public void recalculateUpgradables(Upgrade upgradeType) {}

	@Override
	public int func_174887_a_(int id)
	{
		return 0;
	}

	@Override
	public void func_174885_b(int id, int value) {}

	@Override
	public int func_174890_g()
	{
		return 0;
	}

	@Override
	public void func_174888_l() {}

	@Override
	public ITextComponent func_145748_c_()
	{
		return new TextComponentString(func_70005_c_());
	}
	
	@Override
	public boolean hasCapability(Capability<?> capability, EnumFacing facing)
	{
		return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
	}
	
	private CapabilityWrapperManager itemManager = new CapabilityWrapperManager(ISidedInventory.class, ItemHandlerWrapper.class);

	@Override
	public <T> T getCapability(Capability<T> capability, EnumFacing facing)
	{
		if(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)
		{
			return (T)itemManager.getWrapper(this, facing);
		}
		
		return super.getCapability(capability, facing);
	}
}
