package mekanism.common.tile.component;

import io.netty.buffer.ByteBuf;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

import mekanism.api.Coord4D;
import mekanism.common.Mekanism;
import mekanism.common.Upgrade;
import mekanism.common.base.ITileComponent;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.chunkloading.IChunkLoader;
import mekanism.common.config.MekanismConfig.general;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.ForgeChunkManager.Ticket;
import net.minecraftforge.common.ForgeChunkManager.Type;
import net.minecraftforge.common.util.Constants.NBT;

public class TileComponentChunkLoader implements ITileComponent
{
	/** TileEntity implementing this component. */
	public TileEntityContainerBlock tileEntity;
	
	public Ticket chunkTicket;
	
	public Set<ChunkPos> chunkSet = new HashSet<ChunkPos>();
	
	public Coord4D prevCoord;
	
	public TileComponentChunkLoader(TileEntityContainerBlock tile)
	{
		tileEntity = tile;
		
		tile.components.add(this);
	}
	
	public void setTicket(Ticket t)
	{
		if(chunkTicket != t && chunkTicket != null && chunkTicket.world == tileEntity.func_145831_w())
		{
			for(ChunkPos chunk : chunkTicket.getChunkList())
			{
				if(ForgeChunkManager.getPersistentChunksFor(tileEntity.func_145831_w()).keys().contains(chunk))
				{
					ForgeChunkManager.unforceChunk(chunkTicket, chunk);
				}
			}
			
			ForgeChunkManager.releaseTicket(chunkTicket);
		}
		
		chunkTicket = t;
	}
	
	public void release()
	{
		setTicket(null);
	}
	
	public void sortChunks()
	{
		if(chunkTicket != null)
		{
			for(ChunkPos chunk : chunkTicket.getChunkList())
			{
				if(!chunkSet.contains(chunk))
				{
					if(ForgeChunkManager.getPersistentChunksFor(tileEntity.func_145831_w()).keys().contains(chunk))
					{
						ForgeChunkManager.unforceChunk(chunkTicket, chunk);
					}
				}
			}
			
			for(ChunkPos chunk : chunkSet)
			{
				if(!chunkTicket.getChunkList().contains(chunk))
				{
					ForgeChunkManager.forceChunk(chunkTicket, chunk);
				}
			}
		}
	}
	
	public void refreshChunkSet()
	{
		IChunkLoader loader = (IChunkLoader)tileEntity;
		
		if(!chunkSet.equals(loader.getChunkSet()))
		{
			chunkSet = loader.getChunkSet();
			sortChunks();
		}
	}
	
	public void forceChunks(Ticket ticket)
	{
		setTicket(ticket);
		
		for(ChunkPos chunk : chunkSet)
		{
			ForgeChunkManager.forceChunk(chunkTicket, chunk);
		}
	}
	
	public boolean canOperate()
	{
		return general.allowChunkloading && ((IUpgradeTile)tileEntity).getComponent().getInstalledTypes().contains(Upgrade.ANCHOR);
	}

	@Override
	public void tick() 
	{
		if(!tileEntity.func_145831_w().field_72995_K)
		{			
			if(prevCoord == null || !prevCoord.equals(Coord4D.get(tileEntity)))
			{
				release();
				prevCoord = Coord4D.get(tileEntity);
			}
			
			if(chunkTicket != null && (!canOperate() || chunkTicket.world != tileEntity.func_145831_w()))
			{
				release();
			}
			
			refreshChunkSet();
			
			if(canOperate() && chunkTicket == null)
			{
				Ticket ticket = ForgeChunkManager.requestTicket(Mekanism.instance, tileEntity.func_145831_w(), Type.NORMAL);
	            
				if(ticket != null) 
	            {
					ticket.getModData().func_74768_a("xCoord", tileEntity.func_174877_v().func_177958_n());
					ticket.getModData().func_74768_a("yCoord", tileEntity.func_174877_v().func_177956_o());
					ticket.getModData().func_74768_a("zCoord", tileEntity.func_174877_v().func_177952_p());
					
					forceChunks(ticket);
	            }
			}
		}
	}

	@Override
	public void read(NBTTagCompound nbtTags)
	{
		prevCoord = Coord4D.read(nbtTags.func_74775_l("prevCoord"));
		
		chunkSet.clear();
		NBTTagList list = nbtTags.func_150295_c("chunkSet", NBT.TAG_COMPOUND);
		
		for(int i = 0; i < list.func_74745_c(); i++)
		{
			NBTTagCompound compound = list.func_150305_b(i);
			chunkSet.add(new ChunkPos(compound.func_74762_e("chunkX"), compound.func_74762_e("chunkZ")));
		}
	}

	@Override
	public void read(ByteBuf dataStream) {}

	@Override
	public void write(NBTTagCompound nbtTags) 
	{
		if(prevCoord != null)
		{
			nbtTags.func_74782_a("prevCoord", prevCoord.write(new NBTTagCompound()));
		}
		
		NBTTagList list = new NBTTagList();
		
		for(ChunkPos pos : chunkSet)
		{
			NBTTagCompound compound = new NBTTagCompound();
			compound.func_74768_a("chunkX", pos.field_77276_a);
			compound.func_74768_a("chunkZ", pos.field_77275_b);
			list.func_74742_a(compound);
		}
		
		nbtTags.func_74782_a("chunkSet", list);
	}

	@Override
	public void write(ArrayList<Object> data) {}

	@Override
	public void invalidate() 
	{
		if(!tileEntity.func_145831_w().field_72995_K)
		{
			release();
		}
	}
}
