package mekanism.common.tile;

import java.util.ArrayList;

import mekanism.api.Coord4D;
import mekanism.api.Range4D;
import mekanism.common.Mekanism;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.multiblock.TileEntityInternalMultiblock;
import mekanism.common.network.PacketTileEntity.TileEntityMessage;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.ITickable;

public class TileEntitySuperheatingElement extends TileEntityInternalMultiblock implements ITickable
{
	public boolean prevHot;

	@Override
	public void func_73660_a()
	{
		super.func_73660_a();
	}
	
	@Override
	public void setMultiblock(String id)
	{
		boolean packet = false;
		
		if(id == null && multiblockUUID != null)
		{
			SynchronizedBoilerData.clientHotMap.remove(multiblockUUID);
			packet = true;
		}
		else if(id != null && multiblockUUID == null)
		{
			packet = true;
		}
		
		super.setMultiblock(id);
		
		if(packet && !field_145850_b.field_72995_K)
		{
			Mekanism.packetHandler.sendToReceivers(new TileEntityMessage(Coord4D.get(this), getNetworkedData(new ArrayList<Object>())), new Range4D(Coord4D.get(this)));
		}
	}
	
	@Override
	public void onUpdate()
	{
		if(field_145850_b.field_72995_K)
		{
			boolean newHot = false;
			
			if(multiblockUUID != null && SynchronizedBoilerData.clientHotMap.get(multiblockUUID) != null)
			{
				newHot = SynchronizedBoilerData.clientHotMap.get(multiblockUUID);
			}
			
			if(prevHot != newHot)
			{
				MekanismUtils.updateBlock(field_145850_b, func_174877_v());
				
				prevHot = newHot;
			}
		}
	}
}
