package mekanism.common.tile;

import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.SecurityUtils;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.relauncher.Side;

import mekanism.common.security.ISecurityTile.SecurityMode;

public class TileEntityPersonalChest extends TileEntityContainerBlock implements ISecurityTile
{
	public static int[] INV;

	public float lidAngle;

	public float prevLidAngle;
	
	public TileComponentSecurity securityComponent;

	public TileEntityPersonalChest()
	{
		super("PersonalChest");
		inventory = NonNullList.func_191197_a(54, ItemStack.field_190927_a);
		
		securityComponent = new TileComponentSecurity(this);
	}

	@Override
	public void onUpdate()
	{
		prevLidAngle = lidAngle;
		float increment = 0.1F;

		if((playersUsing.size() > 0) && (lidAngle == 0.0F))
		{
			field_145850_b.func_184148_a(null, func_174877_v().func_177958_n() + 0.5F, func_174877_v().func_177956_o() + 0.5D, func_174877_v().func_177952_p() + 0.5F, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5F, (field_145850_b.field_73012_v.nextFloat()*0.1F) + 0.9F);
		}

		if((playersUsing.size() == 0 && lidAngle > 0.0F) || (playersUsing.size() > 0 && lidAngle < 1.0F))
		{
			float angle = lidAngle;

			if(playersUsing.size() > 0)
			{
				lidAngle += increment;
			}
			else {
				lidAngle -= increment;
			}

			if(lidAngle > 1.0F)
			{
				lidAngle = 1.0F;
			}

			float split = 0.5F;

			if(lidAngle < split && angle >= split)
			{
				field_145850_b.func_184148_a(null, func_174877_v().func_177958_n() + 0.5D, func_174877_v().func_177956_o() + 0.5D, func_174877_v().func_177952_p() + 0.5D, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5F, (field_145850_b.field_73012_v.nextFloat()*0.1F) + 0.9F);
			}

			if(lidAngle < 0.0F)
			{
				lidAngle = 0.0F;
			}
		}
	}

	@Override
	public boolean func_94041_b(int slotID, ItemStack itemstack)
	{
		return true;
	}

	@Override
	public int[] func_180463_a(EnumFacing side)
	{
		if(side == EnumFacing.DOWN || SecurityUtils.getSecurity(this, Side.SERVER) != SecurityMode.PUBLIC)
		{
			return InventoryUtils.EMPTY;
		}
		else {
			if(INV == null)
			{
				INV = new int[54];

				for(int i = 0; i < INV.length; i++)
				{
					INV[i] = i;
				}
			}

			return INV;
		}
	}

	@Override
	public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side)
	{
		return true;
	}

	@Override
	public boolean canSetFacing(int side)
	{
		return side != 0 && side != 1;
	}

	@Override
	public TileComponentSecurity getSecurity() 
	{
		return securityComponent;
	}
}
