package mekanism.common.tile;

import io.netty.buffer.ByteBuf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import mekanism.api.Coord4D;
import mekanism.api.IConfigCardAccess.ISpecialConfigData;
import mekanism.api.Range4D;
import mekanism.common.HashList;
import mekanism.common.Mekanism;
import mekanism.common.OreDictCache;
import mekanism.common.PacketHandler;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISustainedData;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.network.PacketTileEntity.TileEntityMessage;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.Constants.NBT;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.oredict.OreDictionary;

import mekanism.common.base.IRedstoneControl.RedstoneControl;

public class TileEntityOredictionificator extends TileEntityContainerBlock implements IRedstoneControl, ISpecialConfigData, ISustainedData, ISecurityTile
{
	public static final int MAX_LENGTH = 24;
	
	public HashList<OredictionificatorFilter> filters = new HashList<OredictionificatorFilter>();
	
	public static List<String> possibleFilters = Arrays.asList("ingot", "ore", "dust", "nugget");
	
	public RedstoneControl controlType = RedstoneControl.DISABLED;
	
	public boolean didProcess;
	
	public TileComponentSecurity securityComponent = new TileComponentSecurity(this);
	
	public TileEntityOredictionificator()
	{
		super(BlockStateMachine.MachineType.OREDICTIONIFICATOR.blockName);
		
		inventory = NonNullList.func_191197_a(2, ItemStack.field_190927_a);
		doAutoSync = false;
	}

	@Override
	public void onUpdate()
	{
		if(!field_145850_b.field_72995_K)
		{
			if(playersUsing.size() > 0)
			{
				for(EntityPlayer player : playersUsing)
				{
					Mekanism.packetHandler.sendTo(new TileEntityMessage(Coord4D.get(this), getGenericPacket(new ArrayList())), (EntityPlayerMP)player);
				}
			}
			
			didProcess = false;
			
			if(MekanismUtils.canFunction(this) && !inventory.get(0).func_190926_b() && getValidName(inventory.get(0)) != null)
			{
				ItemStack result = getResult(inventory.get(0));
				
				if(!result.func_190926_b())
				{
					if(inventory.get(1).func_190926_b())
					{
						inventory.get(0).func_190918_g(1);
						
						if(inventory.get(0).func_190916_E() <= 0)
						{
							inventory.set(0, ItemStack.field_190927_a);
						}
						
						inventory.set(1, result);
						didProcess = true;
					}
					else if(inventory.get(1).func_77969_a(result) && inventory.get(1).func_190916_E() < inventory.get(1).func_77976_d())
					{
						inventory.get(0).func_190918_g(1);
						
						if(inventory.get(0).func_190916_E() <= 0)
						{
							inventory.set(0, ItemStack.field_190927_a);
						}
						
						inventory.get(1).func_190917_f(1);
						didProcess = true;
					}
					
					func_70296_d();
				}
			}
		}
	}
	
	public String getValidName(ItemStack stack)
	{
		List<String> def = OreDictCache.getOreDictName(stack);
		
		for(String s : def)
		{
			for(String pre : possibleFilters)
			{
				if(s.startsWith(pre))
				{
					return s;
				}
			}
		}
		
		return null;
	}
	
	public ItemStack getResult(ItemStack stack)
	{
		String s = getValidName(stack);
		
		if(s == null)
		{
			return ItemStack.field_190927_a;
		}
		
		List<ItemStack> ores = OreDictionary.getOres(s);
		
		for(OredictionificatorFilter filter : filters)
		{
			if(filter.filter.equals(s))
			{
				if(ores.size()-1 >= filter.index)
				{
					return MekanismUtils.size(ores.get(filter.index), 1);
				}
				else {
					return ItemStack.field_190927_a;
				}
			}
		}
		
		return ItemStack.field_190927_a;
	}
	
	@Override
	public int[] func_180463_a(EnumFacing side)
	{
		if(side == MekanismUtils.getLeft(facing))
		{
			return new int[] {0};
		}
		else if(side == MekanismUtils.getRight(facing))
		{
			return new int[] {1};
		}
		else {
			return InventoryUtils.EMPTY;
		}
	}

	@Override
	public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side)
	{
		return slotID == 1;
	}

	@Override
	public boolean func_94041_b(int slotID, ItemStack itemstack)
	{
		return slotID == 0 && !getResult(itemstack).func_190926_b();

	}
	
	@Override
	public NBTTagCompound func_189515_b(NBTTagCompound nbtTags)
	{
		super.func_189515_b(nbtTags);

		nbtTags.func_74768_a("controlType", controlType.ordinal());

		NBTTagList filterTags = new NBTTagList();

		for(OredictionificatorFilter filter : filters)
		{
			NBTTagCompound tagCompound = new NBTTagCompound();
			filter.write(tagCompound);
			filterTags.func_74742_a(tagCompound);
		}

		if(filterTags.func_74745_c() != 0)
		{
			nbtTags.func_74782_a("filters", filterTags);
		}
		
		return nbtTags;
	}

	@Override
	public void func_145839_a(NBTTagCompound nbtTags)
	{
		super.func_145839_a(nbtTags);

		controlType = RedstoneControl.values()[nbtTags.func_74762_e("controlType")];

		if(nbtTags.func_74764_b("filters"))
		{
			NBTTagList tagList = nbtTags.func_150295_c("filters", NBT.TAG_COMPOUND);

			for(int i = 0; i < tagList.func_74745_c(); i++)
			{
				filters.add(OredictionificatorFilter.readFromNBT(tagList.func_150305_b(i)));
			}
		}
	}
	
	@Override
	public void handlePacketData(ByteBuf dataStream)
	{
		super.handlePacketData(dataStream);

		if(FMLCommonHandler.instance().getEffectiveSide().isClient())
		{
			int type = dataStream.readInt();
	
			if(type == 0)
			{
				controlType = RedstoneControl.values()[dataStream.readInt()];
				didProcess = dataStream.readBoolean();
	
				filters.clear();
	
				int amount = dataStream.readInt();
	
				for(int i = 0; i < amount; i++)
				{
					filters.add(OredictionificatorFilter.readFromPacket(dataStream));
				}
			}
			else if(type == 1)
			{
				controlType = RedstoneControl.values()[dataStream.readInt()];
				didProcess = dataStream.readBoolean();
			}
			else if(type == 2)
			{
				filters.clear();
	
				int amount = dataStream.readInt();
	
				for(int i = 0; i < amount; i++)
				{
					filters.add(OredictionificatorFilter.readFromPacket(dataStream));
				}
			}
		}
	}
	
	@Override
	public ArrayList<Object> getNetworkedData(ArrayList<Object> data)
	{
		super.getNetworkedData(data);

		data.add(0);

		data.add(controlType.ordinal());
		data.add(didProcess);

		data.add(filters.size());

		for(OredictionificatorFilter filter : filters)
		{
			filter.write(data);
		}

		return data;
	}

	public ArrayList getGenericPacket(ArrayList<Object> data)
	{
		super.getNetworkedData(data);

		data.add(1);

		data.add(controlType.ordinal());
		data.add(didProcess);

		return data;

	}

	public ArrayList getFilterPacket(ArrayList<Object> data)
	{
		super.getNetworkedData(data);

		data.add(2);

		data.add(filters.size());

		for(OredictionificatorFilter filter : filters)
		{
			filter.write(data);
		}

		return data;
	}
	
	@Override
	public void func_174889_b(EntityPlayer player)
	{
		if(!field_145850_b.field_72995_K)
		{
			Mekanism.packetHandler.sendToReceivers(new TileEntityMessage(Coord4D.get(this), getFilterPacket(new ArrayList<Object>())), new Range4D(Coord4D.get(this)));
		}
	}
	
	@Override
	public NBTTagCompound getConfigurationData(NBTTagCompound nbtTags)
	{
		NBTTagList filterTags = new NBTTagList();

		for(OredictionificatorFilter filter : filters)
		{
			NBTTagCompound tagCompound = new NBTTagCompound();
			filter.write(tagCompound);
			filterTags.func_74742_a(tagCompound);
		}

		if(filterTags.func_74745_c() != 0)
		{
			nbtTags.func_74782_a("filters", filterTags);
		}
		
		return nbtTags;
	}

	@Override
	public void setConfigurationData(NBTTagCompound nbtTags)
	{
		if(nbtTags.func_74764_b("filters"))
		{
			NBTTagList tagList = nbtTags.func_150295_c("filters", NBT.TAG_COMPOUND);

			for(int i = 0; i < tagList.func_74745_c(); i++)
			{
				filters.add(OredictionificatorFilter.readFromNBT(tagList.func_150305_b(i)));
			}
		}
	}

	@Override
	public String getDataType()
	{
		return func_145838_q().func_149739_a() + "." + fullName + ".name";
	}

	@Override
	public void writeSustainedData(ItemStack itemStack) 
	{
		ItemDataUtils.setBoolean(itemStack, "hasOredictionificatorConfig", true);

		NBTTagList filterTags = new NBTTagList();

		for(OredictionificatorFilter filter : filters)
		{
			NBTTagCompound tagCompound = new NBTTagCompound();
			filter.write(tagCompound);
			filterTags.func_74742_a(tagCompound);
		}

		if(filterTags.func_74745_c() != 0)
		{
			ItemDataUtils.setList(itemStack, "filters", filterTags);
		}
	}

	@Override
	public void readSustainedData(ItemStack itemStack) 
	{
		if(ItemDataUtils.hasData(itemStack, "hasOredictionificatorConfig"))
		{
			if(ItemDataUtils.hasData(itemStack, "filters"))
			{
				NBTTagList tagList = ItemDataUtils.getList(itemStack, "filters");

				for(int i = 0; i < tagList.func_74745_c(); i++)
				{
					filters.add(OredictionificatorFilter.readFromNBT(tagList.func_150305_b(i)));
				}
			}
		}
	}
	
	@Override
	public RedstoneControl getControlType()
	{
		return controlType;
	}

	@Override
	public void setControlType(RedstoneControl type)
	{
		controlType = type;
	}

	@Override
	public boolean canPulse()
	{
		return true;
	}
	
	@Override
	public TileComponentSecurity getSecurity()
	{
		return securityComponent;
	}
	
	@Override
	public boolean hasCapability(Capability<?> capability, EnumFacing side)
	{
		return capability == Capabilities.CONFIG_CARD_CAPABILITY || capability == Capabilities.SPECIAL_CONFIG_DATA_CAPABILITY 
				|| super.hasCapability(capability, side);
	}

	@Override
	public <T> T getCapability(Capability<T> capability, EnumFacing side)
	{
		if(capability == Capabilities.CONFIG_CARD_CAPABILITY || capability == Capabilities.SPECIAL_CONFIG_DATA_CAPABILITY)
		{
			return (T)this;
		}
		
		return super.getCapability(capability, side);
	}
	
	public static class OredictionificatorFilter
	{
		public String filter;
		public int index;
		
		public void write(NBTTagCompound nbtTags)
		{
			nbtTags.func_74778_a("filter", filter);
			nbtTags.func_74768_a("index", index);
		}

		protected void read(NBTTagCompound nbtTags)
		{
			filter = nbtTags.func_74779_i("filter");
			index = nbtTags.func_74762_e("index");
		}

		public void write(ArrayList<Object> data)
		{
			data.add(filter);
			data.add(index);
		}

		protected void read(ByteBuf dataStream)
		{
			filter = PacketHandler.readString(dataStream);
			index = dataStream.readInt();
		}

		public static OredictionificatorFilter readFromNBT(NBTTagCompound nbtTags)
		{
			OredictionificatorFilter filter = new OredictionificatorFilter();

			filter.read(nbtTags);

			return filter;
		}

		public static OredictionificatorFilter readFromPacket(ByteBuf dataStream)
		{
			OredictionificatorFilter filter = new OredictionificatorFilter();

			filter.read(dataStream);

			return filter;
		}
		
		@Override
		public OredictionificatorFilter clone()
		{
			OredictionificatorFilter newFilter = new OredictionificatorFilter();
			newFilter.filter = filter;
			newFilter.index = index;

			return newFilter;
		}

		@Override
		public int hashCode()
		{
			int code = 1;
			code = 31 * code + filter.hashCode();
			return code;
		}

		@Override
		public boolean equals(Object obj)
		{
			return obj instanceof OredictionificatorFilter && ((OredictionificatorFilter)obj).filter.equals(filter);
		}
	}
}
