package mekanism.common.tile;

import io.netty.buffer.ByteBuf;

import java.util.ArrayList;
import java.util.List;

import mekanism.api.Coord4D;
import mekanism.api.lasers.ILaserReceptor;
import mekanism.common.LaserManager;
import mekanism.common.LaserManager.LaserInfo;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig.general;
import mekanism.common.network.PacketTileEntity.TileEntityMessage;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityLaserTractorBeam extends TileEntityContainerBlock implements ILaserReceptor, ISecurityTile
{
	public static final double MAX_ENERGY = 5E9;
	public double collectedEnergy = 0;
	public double lastFired = 0;

	public boolean on = false;

	public Coord4D digging;
	public double diggingProgress;

	public static int[] availableSlotIDs = InventoryUtils.getIntRange(0, 26);
	
	public TileComponentSecurity securityComponent = new TileComponentSecurity(this);

	public TileEntityLaserTractorBeam()
	{
		super("LaserTractorBeam");
		inventory = NonNullList.func_191197_a(27, ItemStack.field_190927_a);
	}

	@Override
	public void receiveLaserEnergy(double energy, EnumFacing side)
	{
		setEnergy(getEnergy() + energy);
	}

	@Override
	public boolean canLasersDig()
	{
		return false;
	}

	@Override
	public void onUpdate()
	{
		if(field_145850_b.field_72995_K)
		{
			if(on)
			{
				RayTraceResult mop = LaserManager.fireLaserClient(this, facing, lastFired, field_145850_b);
				Coord4D hitCoord = mop == null ? null : new Coord4D(mop, field_145850_b);

				if(hitCoord == null || !hitCoord.equals(digging))
				{
					digging = hitCoord;
					diggingProgress = 0;
				}

				if(hitCoord != null)
				{
					IBlockState blockHit = hitCoord.getBlockState(field_145850_b);
					TileEntity tileHit = hitCoord.getTileEntity(field_145850_b);
					float hardness = blockHit.func_185887_b(field_145850_b, hitCoord.getPos());
					
					if(!(hardness < 0 || (LaserManager.isReceptor(tileHit, mop.field_178784_b) && !(LaserManager.getReceptor(tileHit, mop.field_178784_b).canLasersDig()))))
					{
						diggingProgress += lastFired;

						if(diggingProgress < hardness * general.laserEnergyNeededPerHardness)
						{
							Mekanism.proxy.addHitEffects(hitCoord, mop);
						}
					}
				}

			}
		}
		else {
			if(collectedEnergy > 0)
			{
				double firing = collectedEnergy;

				if(!on || firing != lastFired)
				{
					on = true;
					lastFired = firing;
					Mekanism.packetHandler.sendToAllAround(new TileEntityMessage(Coord4D.get(this), getNetworkedData(new ArrayList<Object>())), Coord4D.get(this).getTargetPoint(50D));
				}

				LaserInfo info = LaserManager.fireLaser(this, facing, firing, field_145850_b);
				Coord4D hitCoord = info.movingPos == null ? null : new Coord4D(info.movingPos, field_145850_b);

				if(hitCoord == null || !hitCoord.equals(digging))
				{
					digging = hitCoord;
					diggingProgress = 0;
				}

				if(hitCoord != null)
				{
					IBlockState blockHit = hitCoord.getBlockState(field_145850_b);
					TileEntity tileHit = hitCoord.getTileEntity(field_145850_b);
					float hardness = blockHit.func_185887_b(field_145850_b, hitCoord.getPos());
					
					if(!(hardness < 0 || (LaserManager.isReceptor(tileHit, info.movingPos.field_178784_b) && !(LaserManager.getReceptor(tileHit, info.movingPos.field_178784_b).canLasersDig()))))
					{
						diggingProgress += firing;

						if(diggingProgress >= hardness * general.laserEnergyNeededPerHardness)
						{
							List<ItemStack> drops = LaserManager.breakBlock(hitCoord, false, field_145850_b);
							if(drops != null) receiveDrops(drops);
							diggingProgress = 0;
						}
					}
				}

				setEnergy(getEnergy() - firing);
			}
			else if(on)
			{
				on = false;
				diggingProgress = 0;
				Mekanism.packetHandler.sendToAllAround(new TileEntityMessage(Coord4D.get(this), getNetworkedData(new ArrayList<Object>())), Coord4D.get(this).getTargetPoint(50D));
			}
		}
	}

	public void setEnergy(double energy)
	{
		collectedEnergy = Math.max(0, Math.min(energy, MAX_ENERGY));
	}

	public double getEnergy()
	{
		return collectedEnergy;
	}

	public void receiveDrops(List<ItemStack> drops)
	{
		outer:
		for(ItemStack drop : drops)
		{
			for(int i = 0; i < inventory.size(); i++)
			{
				if(inventory.get(i).func_190926_b())
				{
					inventory.set(i, drop);
					continue outer;
				}
				
				ItemStack slot = inventory.get(i);
				
				if(StackUtils.equalsWildcardWithNBT(slot, drop))
				{
					int change = Math.min(drop.func_190916_E(), slot.func_77976_d() - slot.func_190916_E());
					slot.func_190917_f(change);
					drop.func_190918_g(change);
					if(drop.func_190916_E() <= 0) continue outer;
				}
			}
			
			dropItem(drop);
		}
	}

	public void dropItem(ItemStack stack)
	{
		EntityItem item = new EntityItem(field_145850_b, func_174877_v().func_177958_n() + 0.5, func_174877_v().func_177956_o() + 1, func_174877_v().func_177952_p() + 0.5, stack);
		item.field_70159_w = field_145850_b.field_73012_v.nextGaussian() * 0.05;
		item.field_70181_x = field_145850_b.field_73012_v.nextGaussian() * 0.05 + 0.2;
		item.field_70179_y = field_145850_b.field_73012_v.nextGaussian() * 0.05;
		item.func_174867_a(10);
		field_145850_b.func_72838_d(item);
	}

	@Override
	public boolean func_180462_a(int i, ItemStack itemStack, EnumFacing side)
	{
		return false;
	}

	@Override
	public int[] func_180463_a(EnumFacing side)
	{
		return availableSlotIDs;
	}

	@Override
	public ArrayList<Object> getNetworkedData(ArrayList<Object> data)
	{
		super.getNetworkedData(data);

		data.add(on);
		data.add(collectedEnergy);
		data.add(lastFired);

		return data;
	}

	@Override
	public void handlePacketData(ByteBuf dataStream)
	{
		super.handlePacketData(dataStream);
		
		if(FMLCommonHandler.instance().getEffectiveSide().isClient())
		{
			on = dataStream.readBoolean();
			collectedEnergy = dataStream.readDouble();
			lastFired = dataStream.readDouble();
		}
	}
	
	@Override
	public TileComponentSecurity getSecurity()
	{
		return securityComponent;
	}
	
	@Override
	public boolean hasCapability(Capability<?> capability, EnumFacing side)
	{
		return capability == Capabilities.LASER_RECEPTOR_CAPABILITY || super.hasCapability(capability, side);
	}

	@Override
	public <T> T getCapability(Capability<T> capability, EnumFacing side)
	{
		if(capability == Capabilities.LASER_RECEPTOR_CAPABILITY)
		{
			return (T)this;
		}
		
		return super.getCapability(capability, side);
	}
}
