package mekanism.common.tile;

import io.netty.buffer.ByteBuf;

import java.util.ArrayList;
import java.util.EnumSet;

import mekanism.api.Coord4D;
import mekanism.api.Range4D;
import mekanism.api.lasers.ILaserReceptor;
import mekanism.common.LaserManager;
import mekanism.common.LaserManager.LaserInfo;
import mekanism.common.Mekanism;
import mekanism.common.base.IActiveState;
import mekanism.common.config.MekanismConfig.general;
import mekanism.common.config.MekanismConfig.usage;
import mekanism.common.network.PacketTileEntity.TileEntityMessage;
import mekanism.common.tile.prefab.TileEntityNoisyBlock;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityLaser extends TileEntityNoisyBlock implements IActiveState
{
	public Coord4D digging;
	public double diggingProgress;
	
	public boolean isActive;

	public boolean clientActive;

	public TileEntityLaser()
	{
		super("machine.laser", "Laser", 2*usage.laserUsage);
		inventory = NonNullList.func_191197_a(0, ItemStack.field_190927_a);
	}

	@Override
	public void onUpdate()
	{
		super.onUpdate();

		if(field_145850_b.field_72995_K)
		{
			if(isActive)
			{
				RayTraceResult mop = LaserManager.fireLaserClient(this, facing, usage.laserUsage, field_145850_b);
				Coord4D hitCoord = mop == null ? null : new Coord4D(mop, field_145850_b);

				if(hitCoord == null || !hitCoord.equals(digging))
				{
					digging = hitCoord;
					diggingProgress = 0;
				}

				if(hitCoord != null)
				{
					IBlockState blockHit = hitCoord.getBlockState(field_145850_b);
					TileEntity tileHit = hitCoord.getTileEntity(field_145850_b);
					float hardness = blockHit.func_185887_b(field_145850_b, hitCoord.getPos());

					if(!(hardness < 0 || (LaserManager.isReceptor(tileHit, mop.field_178784_b) && !(LaserManager.getReceptor(tileHit, mop.field_178784_b).canLasersDig()))))
					{
						diggingProgress += usage.laserUsage;

						if(diggingProgress < hardness*general.laserEnergyNeededPerHardness)
						{
							Mekanism.proxy.addHitEffects(hitCoord, mop);
						}
					}
				}
			}
		}
		else {
			if(getEnergy() >= usage.laserUsage)
			{
				setActive(true);
				
				LaserInfo info = LaserManager.fireLaser(this, facing, usage.laserUsage, field_145850_b);
				Coord4D hitCoord = info.movingPos == null ? null : new Coord4D(info.movingPos, field_145850_b);

				if(hitCoord == null || !hitCoord.equals(digging))
				{
					digging = hitCoord;
					diggingProgress = 0;
				}

				if(hitCoord != null)
				{
					IBlockState blockHit = hitCoord.getBlockState(field_145850_b);
					TileEntity tileHit = hitCoord.getTileEntity(field_145850_b);
					float hardness = blockHit.func_185887_b(field_145850_b, hitCoord.getPos());
					
					if(!(hardness < 0 || (LaserManager.isReceptor(tileHit, info.movingPos.field_178784_b) && !(LaserManager.getReceptor(tileHit, info.movingPos.field_178784_b).canLasersDig()))))
					{
						diggingProgress += usage.laserUsage;

						if(diggingProgress >= hardness*general.laserEnergyNeededPerHardness)
						{
							LaserManager.breakBlock(hitCoord, true, field_145850_b);
							diggingProgress = 0;
						}
					}
				}

				setEnergy(getEnergy() - usage.laserUsage);
			}
			else {
				setActive(false);
				diggingProgress = 0;
			}
		}
	}
	
	@Override
	public boolean sideIsConsumer(EnumFacing side) 
	{
		return side == facing.func_176734_d();
	}

	@Override
	public void setActive(boolean active)
	{
		isActive = active;

		if(clientActive != active)
		{
			Mekanism.packetHandler.sendToReceivers(new TileEntityMessage(Coord4D.get(this), getNetworkedData(new ArrayList<Object>())), new Range4D(Coord4D.get(this)));
			clientActive = active;
		}
	}

	@Override
	public boolean getActive()
	{
		return isActive;
	}

	@Override
	public boolean renderUpdate()
	{
		return false;
	}

	@Override
	public boolean lightUpdate()
	{
		return false;
	}

	@Override
	public ArrayList<Object> getNetworkedData(ArrayList<Object> data)
	{
		super.getNetworkedData(data);

		data.add(isActive);

		return data;
	}

	@Override
	public void handlePacketData(ByteBuf dataStream)
	{
		super.handlePacketData(dataStream);

		if(FMLCommonHandler.instance().getEffectiveSide().isClient())
		{
			clientActive = dataStream.readBoolean();
			
			if(clientActive != isActive)
			{
				isActive = clientActive;
				MekanismUtils.updateBlock(field_145850_b, func_174877_v());
			}
		}
	}
	
	@Override
	public void func_145839_a(NBTTagCompound nbtTags)
	{
		super.func_145839_a(nbtTags);

		isActive = nbtTags.func_74767_n("isActive");
	}

	@Override
	public NBTTagCompound func_189515_b(NBTTagCompound nbtTags)
	{
		super.func_189515_b(nbtTags);

		nbtTags.func_74757_a("isActive", isActive);
		
		return nbtTags;
	}
}
