package mekanism.common.tile;

import io.netty.buffer.ByteBuf;

import java.util.ArrayList;

import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.common.Tier.InductionCellTier;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.tile.prefab.TileEntityBasicBlock;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityInductionCell extends TileEntityBasicBlock implements IStrictEnergyStorage
{
	public InductionCellTier tier = InductionCellTier.BASIC;
	
	public double electricityStored;
	
	@Override
	public void onUpdate() {}
	
	public String getName()
	{
		return LangUtils.localize(func_145838_q().func_149739_a() + ".InductionCell" + tier.getBaseTier().getSimpleName() + ".name");
	}
	
	@Override
	public void handlePacketData(ByteBuf dataStream)
	{		
		if(FMLCommonHandler.instance().getEffectiveSide().isClient())
		{
			InductionCellTier prevTier = tier;
			
			tier = InductionCellTier.values()[dataStream.readInt()];
			
			super.handlePacketData(dataStream);
			
			electricityStored = dataStream.readDouble();
	
			if(prevTier != tier)
			{
				MekanismUtils.updateBlock(field_145850_b, func_174877_v());
			}
		}
	}

	@Override
	public ArrayList<Object> getNetworkedData(ArrayList<Object> data)
	{
		data.add(tier.ordinal());

		super.getNetworkedData(data);
		
		data.add(electricityStored);

		return data;
	}

	@Override
	public void func_145839_a(NBTTagCompound nbtTags)
	{
		super.func_145839_a(nbtTags);

		tier = InductionCellTier.values()[nbtTags.func_74762_e("tier")];
		electricityStored = nbtTags.func_74769_h("electricityStored");
	}

	@Override
	public NBTTagCompound func_189515_b(NBTTagCompound nbtTags)
	{
		super.func_189515_b(nbtTags);

		nbtTags.func_74768_a("tier", tier.ordinal());
		nbtTags.func_74780_a("electricityStored", electricityStored);
		
		return nbtTags;
	}

	@Override
	public double getEnergy() 
	{
		return electricityStored;
	}

	@Override
	public void setEnergy(double energy) 
	{
		electricityStored = Math.min(energy, getMaxEnergy());
	}

	@Override
	public double getMaxEnergy() 
	{
		return tier.maxEnergy;
	}

	@Override
	public boolean hasCapability(net.minecraftforge.common.capabilities.Capability<?> capability, net.minecraft.util.EnumFacing facing)
	{
		return capability == Capabilities.ENERGY_STORAGE_CAPABILITY || super.hasCapability(capability, facing);
	}

	@Override
	public <T> T getCapability(Capability<T> capability, net.minecraft.util.EnumFacing facing)
	{
		if (capability == Capabilities.ENERGY_STORAGE_CAPABILITY)
			return (T) this;
		return super.getCapability(capability, facing);
	}
}
