package mekanism.common.tile;

import io.netty.buffer.ByteBuf;

import java.util.ArrayList;

import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.base.ITileNetwork;
import mekanism.common.block.property.PropertyColor;
import mekanism.common.block.states.BlockStateFacing;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.integration.multipart.MultipartTileNetworkJoiner;
import mekanism.common.network.PacketDataRequest.DataRequestMessage;
import mekanism.common.util.MekanismUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.property.IExtendedBlockState;

public class TileEntityGlowPanel extends TileEntity implements ITileNetwork
{
	public EnumColor colour = EnumColor.WHITE;
	public EnumFacing side = EnumFacing.DOWN;

	public void setColour(EnumColor newColour)
	{
		colour = newColour;
	}

	public void setOrientation(EnumFacing newSide)
	{
		side = newSide;
	}
	
	@Override
	public void handlePacketData(ByteBuf dataStream) throws Exception 
	{
		side = EnumFacing.func_82600_a(dataStream.readInt());
		colour = EnumColor.DYES[dataStream.readInt()];
		
		MekanismUtils.updateBlock(field_145850_b, field_174879_c);
	}
	
	@Override
	public ArrayList<Object> getNetworkedData(ArrayList<Object> data)
	{
		if(Mekanism.hooks.MCMPLoaded)
		{
			MultipartTileNetworkJoiner.addMultipartHeader(this, data, side);
		}
		
		data.add(side.ordinal());
		data.add(colour.getMetaValue());
		
		return data;
	}
	
	@Override
	public void func_145829_t()
	{
		super.func_145829_t();

		if(field_145850_b.field_72995_K)
		{
			Mekanism.packetHandler.sendToServer(new DataRequestMessage(Coord4D.get(this)));
		}
	}

	@Override
	public NBTTagCompound func_189515_b(NBTTagCompound nbt)
	{
		super.func_189515_b(nbt);
		
		nbt.func_74768_a("side", side.ordinal());
		nbt.func_74768_a("colour", colour.getMetaValue());
		
		return nbt;
	}
	
	@Override
	public NBTTagCompound func_189517_E_()
	{
		return func_189515_b(new NBTTagCompound());
	}

	@Override
	public void func_145839_a(NBTTagCompound nbt)
	{
		super.func_145839_a(nbt);
		
		side = EnumFacing.func_82600_a(nbt.func_74762_e("side"));
		colour = EnumColor.DYES[nbt.func_74762_e("colour")];
	}
	
	@Override
	public boolean hasCapability(Capability<?> capability, EnumFacing facing)
	{
		return capability == Capabilities.TILE_NETWORK_CAPABILITY || super.hasCapability(capability, facing);
	}

	@Override
	public <T> T getCapability(Capability<T> capability, EnumFacing facing)
	{
		if(capability == Capabilities.TILE_NETWORK_CAPABILITY)
			return (T)this;
		return super.getCapability(capability, facing);
	}
	
	public static int hash(IExtendedBlockState state)
	{
		int hash = 1;
		hash = 31 * hash + state.getValue(PropertyColor.INSTANCE).color.ordinal();
		hash = 31 * hash + state.func_177229_b(BlockStateFacing.facingProperty).ordinal();
		
		return hash;
	}
}
