package mekanism.common.tile;

import io.netty.buffer.ByteBuf;

import java.util.ArrayList;
import java.util.List;

import mekanism.api.EnumColor;
import mekanism.api.IConfigCardAccess;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.PacketHandler;
import mekanism.common.SideData;
import mekanism.common.Upgrade;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.block.states.BlockStateMachine.MachineType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig.usage;
import mekanism.common.content.assemblicator.RecipeFormula;
import mekanism.common.item.ItemCraftingFormula;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.tile.prefab.TileEntityElectricBlock;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;

import mekanism.common.base.IRedstoneControl.RedstoneControl;

public class TileEntityFormulaicAssemblicator extends TileEntityElectricBlock implements ISideConfiguration, IUpgradeTile, IRedstoneControl, IConfigCardAccess, ISecurityTile
{
	public InventoryCrafting dummyInv = MekanismUtils.getDummyCraftingInv();
	
	public double BASE_ENERGY_PER_TICK = usage.metallurgicInfuserUsage;

	public double energyPerTick = BASE_ENERGY_PER_TICK;

	public int BASE_TICKS_REQUIRED = 40;

	public int ticksRequired = BASE_TICKS_REQUIRED;
	
	public int operatingTicks;
	
	public boolean autoMode = false;
	
	public boolean isRecipe = false;
	
	public boolean stockControl = false;
	public boolean needsOrganize = true; //organize on load
	
	public int pulseOperations;
	
	public RecipeFormula formula;
	
	public RedstoneControl controlType = RedstoneControl.DISABLED;
	
	public TileComponentUpgrade upgradeComponent;
	public TileComponentEjector ejectorComponent;
	public TileComponentConfig configComponent;
	public TileComponentSecurity securityComponent;
	
	public ItemStack lastFormulaStack = ItemStack.field_190927_a;
	public boolean needsFormulaUpdate = false;
	public ItemStack lastOutputStack = ItemStack.field_190927_a;
	
	public TileEntityFormulaicAssemblicator()
	{
		super("FormulaicAssemblicator", MachineType.FORMULAIC_ASSEMBLICATOR.baseEnergy);
		
		configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY);
		
		configComponent.addOutput(TransmissionType.ITEM, new SideData("None", EnumColor.GREY, InventoryUtils.EMPTY));
		configComponent.addOutput(TransmissionType.ITEM, new SideData("Input", EnumColor.DARK_RED, 
				new int[] {3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20}));
		configComponent.addOutput(TransmissionType.ITEM, new SideData("Output", EnumColor.DARK_BLUE, new int[] {21, 22, 23, 24, 25, 26}));
		configComponent.addOutput(TransmissionType.ITEM, new SideData("Energy", EnumColor.DARK_GREEN, new int[] {1}));
		
		configComponent.setConfig(TransmissionType.ITEM, new byte[] {0, 0, 0, 3, 1, 2});
		configComponent.setInputConfig(TransmissionType.ENERGY);
		
		inventory = NonNullList.func_191197_a(36, ItemStack.field_190927_a);
		
		upgradeComponent = new TileComponentUpgrade(this, 0);
		
		ejectorComponent = new TileComponentEjector(this);
		ejectorComponent.setOutputData(TransmissionType.ITEM, configComponent.getOutputs(TransmissionType.ITEM).get(2));
		
		securityComponent = new TileComponentSecurity(this);
	}
	
	@Override
	public void onUpdate()
	{
		super.onUpdate();
		
		if(!field_145850_b.field_72995_K)
		{
			if(formula != null && stockControl && needsOrganize)
			{
				needsOrganize = false;
				organizeStock();
			}
			
			ChargeUtils.discharge(1, this);
			
			if(controlType != RedstoneControl.PULSE)
			{
				pulseOperations = 0;
			}
			else if(MekanismUtils.canFunction(this))
			{
				pulseOperations++;
			}
			
			RecipeFormula prev = formula;
			
			if(!inventory.get(2).func_190926_b() && inventory.get(2).func_77973_b() instanceof ItemCraftingFormula)
			{
				ItemCraftingFormula item = (ItemCraftingFormula)inventory.get(2).func_77973_b();
				
				if(formula == null || lastFormulaStack != inventory.get(2))
				{
					loadFormula();
				}
			}
			else {
				formula = null;
			}
			
			if(prev != formula)
			{
				needsFormulaUpdate = true;
			}
			
			lastFormulaStack = inventory.get(2);
			
			if(autoMode && formula == null)
			{
				toggleAutoMode();
			}
			
			if(autoMode && formula != null && ((controlType == RedstoneControl.PULSE && pulseOperations > 0) || MekanismUtils.canFunction(this)))
			{
				boolean canOperate = true;
				
				if(!isRecipe)
				{
					canOperate = moveItemsToGrid();
				}
				
				if(canOperate)
				{
					isRecipe = true;
					
					if(operatingTicks >= ticksRequired)
					{
						if(doSingleCraft())
						{
							operatingTicks = 0;
							
							if(pulseOperations > 0)
							{
								pulseOperations--;
							}
							
							ejectorComponent.outputItems();
						}
					}
					else {
						if(getEnergy() >= energyPerTick)
						{
							operatingTicks++;
							setEnergy(getEnergy() - energyPerTick);
						}
					}
				}
				else {
					operatingTicks = 0;
				}
			}
			else {
				operatingTicks = 0;
			}
		}
	}
	
	public void loadFormula()
	{
		ItemCraftingFormula item = (ItemCraftingFormula)inventory.get(2).func_77973_b();
		
		if(item.getInventory(inventory.get(2)) != null && !item.isInvalid(inventory.get(2)))
		{
			RecipeFormula itemFormula = new RecipeFormula(field_145850_b, item.getInventory(inventory.get(2)));
			
			if(itemFormula.isValidFormula(field_145850_b))
			{
				if(formula != null && !formula.isFormulaEqual(field_145850_b, itemFormula))
				{
					formula = itemFormula;
					operatingTicks = 0;
				}
				else if(formula == null)
				{
					formula = itemFormula;
				}
			}
			else {
				formula = null;
				item.setInvalid(inventory.get(2), true);
			}
		}
		else {
			formula = null;
		}
	}
	
	@Override
	public void func_70296_d()
	{
		super.func_70296_d();
		
		if(field_145850_b != null && !field_145850_b.field_72995_K)
		{
			if(formula == null)
			{
				for(int i = 0; i < 9; i++)
				{
					dummyInv.func_70299_a(i, inventory.get(27+i));
				}
				
				lastOutputStack = MekanismUtils.findMatchingRecipe(dummyInv, field_145850_b);
				isRecipe = !lastOutputStack.func_190926_b();
			}
			else {
				isRecipe = formula.matches(field_145850_b, inventory, 27);
				lastOutputStack = isRecipe ? formula.recipe.func_77571_b() : ItemStack.field_190927_a;
			}
			
			needsOrganize = true;
		}
	}
	
	private boolean doSingleCraft()
	{
		for(int i = 0; i < 9; i++)
		{
			dummyInv.func_70299_a(i, inventory.get(27+i));
		}
		
		ItemStack output = lastOutputStack;
		
		if(!output.func_190926_b() && tryMoveToOutput(output, false))
		{
			tryMoveToOutput(output, true);
			
			for(int i = 27; i <= 35; i++)
			{
				if(!inventory.get(i).func_190926_b())
				{
					ItemStack stack = inventory.get(i).func_77946_l();
					
					inventory.get(i).func_190918_g(1);
					
					if(inventory.get(i).func_190916_E() == 0 && stack.func_77973_b().hasContainerItem(stack))
					{
						ItemStack container = stack.func_77973_b().getContainerItem(stack);

	                    if(!container.func_190926_b() && container.func_77984_f() && container.func_77952_i() > container.func_77958_k())
	                    {
	                    	container = ItemStack.field_190927_a;
	                    }

	                    if(!container.func_190926_b())
	                    {
                    		boolean move = tryMoveToOutput(container.func_77946_l(), false);
                    		
                    		if(move)
                    		{
                    			tryMoveToOutput(container.func_77946_l(), true);
                    		}
                    		
                    		inventory.set(i, move ? ItemStack.field_190927_a : container.func_77946_l());
	                    }
					}
				}
			}
			
			if(formula != null)
			{
				moveItemsToGrid();
			}
			
			func_70296_d();
			
			return true;
		}
		
		return false;
	}
	
	private boolean craftSingle()
	{
		if(formula != null)
		{
			boolean canOperate = true;
			
			if(!formula.matches(field_145850_b, inventory, 27))
			{
				canOperate = moveItemsToGrid();
			}
			
			if(canOperate)
			{
				return doSingleCraft();
			}
		}
		else {
			return doSingleCraft();
		}
		
		return false;
	}
	
	private boolean moveItemsToGrid()
	{
		boolean ret = true;
		
		for(int i = 27; i <= 35; i++)
		{
			if(formula.isIngredientInPos(field_145850_b, inventory.get(i), i-27))
			{
				continue;
			}
			
			if(!inventory.get(i).func_190926_b())
			{
				inventory.set(i, tryMoveToInput(inventory.get(i)));
				func_70296_d();
				
				if(!inventory.get(i).func_190926_b())
				{
					ret = false;
				}
			}
			else {
				boolean found = false;
				
				for(int j = 20; j >= 3; j--)
				{
					if(!inventory.get(j).func_190926_b() && formula.isIngredientInPos(field_145850_b, inventory.get(j), i-27))
					{
						inventory.set(i, StackUtils.size(inventory.get(j), 1));
						inventory.get(j).func_190918_g(1);
						
						func_70296_d();
						found = true;
						
						break;
					}
				}
				
				if(!found)
				{
					ret = false;
				}
			}
		}
		
		return ret;
	}
	
	private void craftAll()
	{
		while(craftSingle());
	}
	
	private void moveItemsToInput(boolean forcePush)
	{
		for(int i = 27; i <= 35; i++)
		{
			if(!inventory.get(i).func_190926_b() && (forcePush || (formula != null && !formula.isIngredientInPos(field_145850_b, inventory.get(i), i-27))))
			{
				inventory.set(i, tryMoveToInput(inventory.get(i)));
			}
		}
		
		func_70296_d();
	}
	
	private void toggleAutoMode()
	{
		if(autoMode)
		{
			operatingTicks = 0;
			autoMode = false;
		}
		else if(formula != null)
		{
			moveItemsToInput(false);
			autoMode = true;
		}
		
		func_70296_d();
	}
	
	private void toggleStockControl()
	{
		if(!field_145850_b.field_72995_K && formula != null)
		{
			stockControl = !stockControl;
			
			if(stockControl)
			{
				organizeStock();
			}
		}
	}
	
	private void organizeStock()
	{
		for(int j = 3; j <= 20; j++)
		{
			for(int i = 20; i > j; i--)
			{
				if(!inventory.get(i).func_190926_b())
				{
					if(inventory.get(j).func_190926_b())
					{
						inventory.set(j, inventory.get(i));
						inventory.set(i, ItemStack.field_190927_a);
						func_70296_d();
						return;
					}
					else if(inventory.get(j).func_190916_E() < inventory.get(j).func_77976_d())
					{
						if(InventoryUtils.areItemsStackable(inventory.get(i), inventory.get(j)))
						{
							int newCount = inventory.get(j).func_190916_E() + inventory.get(i).func_190916_E();
							inventory.get(j).func_190920_e(Math.min(inventory.get(j).func_77976_d(), newCount));
							inventory.get(i).func_190920_e(Math.max(0, newCount - inventory.get(j).func_77976_d()));
							func_70296_d();
							return;
						}
					}
				}
			}
		}
	}
	
	private ItemStack tryMoveToInput(ItemStack stack)
	{
		stack = stack.func_77946_l();
		
		for(int i = 3; i <= 20; i++)
		{
			if(inventory.get(i).func_190926_b())
			{
				inventory.set(i, stack);
				
				return ItemStack.field_190927_a;
			}
			else if(InventoryUtils.areItemsStackable(stack, inventory.get(i)) && inventory.get(i).func_190916_E() < inventory.get(i).func_77976_d())
			{
				int toUse = Math.min(stack.func_190916_E(), inventory.get(i).func_77976_d()-inventory.get(i).func_190916_E());
				
				inventory.get(i).func_190917_f(toUse);
				stack.func_190918_g(toUse);
				
				if(stack.func_190916_E() == 0)
				{
					return ItemStack.field_190927_a;
				}
			}
		}
		
		return stack;
	}
	
	private boolean tryMoveToOutput(ItemStack stack, boolean doMove)
	{
		stack = stack.func_77946_l();
		
		for(int i = 21; i <= 26; i++)
		{
			if(inventory.get(i).func_190926_b())
			{
				if(doMove)
				{
					inventory.set(i, stack);
				}
				
				return true;
			}
			else if(InventoryUtils.areItemsStackable(stack, inventory.get(i)) && inventory.get(i).func_190916_E() < inventory.get(i).func_77976_d())
			{
				int toUse = Math.min(stack.func_190916_E(), inventory.get(i).func_77976_d()-inventory.get(i).func_190916_E());
				
				if(doMove)
				{
					inventory.get(i).func_190917_f(toUse);
				}
				
				stack.func_190918_g(toUse);
				
				if(stack.func_190916_E() == 0)
				{
					return true;
				}
			}
		}
		
		return false;
	}
	
	private void encodeFormula()
	{
		if(!inventory.get(2).func_190926_b() && inventory.get(2).func_77973_b() instanceof ItemCraftingFormula)
		{
			ItemCraftingFormula item = (ItemCraftingFormula)inventory.get(2).func_77973_b();
			
			if(item.getInventory(inventory.get(2)) == null)
			{
				RecipeFormula formula = new RecipeFormula(field_145850_b, inventory, 27);
				
				if(formula.isValidFormula(field_145850_b))
				{
					item.setInventory(inventory.get(2), formula.input);
					func_70296_d();
				}
			}
		}
	}
	
	@Override
	public boolean canSetFacing(int side)
	{
		return side != 0 && side != 1;
	}
	
	@Override
	public int[] func_180463_a(EnumFacing side)
	{
		return configComponent.getOutput(TransmissionType.ITEM, side, facing).availableSlots;
	}
	
	@Override
	public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side)
	{
		if(slotID == 1)
		{
			return ChargeUtils.canBeOutputted(itemstack, false);
		}
		else if(slotID >= 21 && slotID <= 26)
		{
			return true;
		}

		return false;
	}

	@Override
	public boolean func_94041_b(int slotID, ItemStack itemstack)
	{
		if(slotID >= 3 && slotID <= 20)
		{
			if(formula == null)
			{
				return true;
			}
			else {
				List<Integer> indices = formula.getIngredientIndices(field_145850_b, itemstack);
				
				if(indices.size() > 0)
				{
					if(stockControl)
					{
						int filled = 0;
						
						for(int i = 3; i < 20; i++)
						{
							if(!inventory.get(i).func_190926_b())
							{
								if(formula.isIngredientInPos(field_145850_b, inventory.get(i), indices.get(0)))
								{
									filled++;
								}
							}
						}
						
						return filled < indices.size()*2;
					}
					else {
						return true;
					}
				}
			}
		}
		else if(slotID == 1)
		{
			return ChargeUtils.canBeDischarged(itemstack);
		}

		return false;
	}

	@Override
	public void func_145839_a(NBTTagCompound nbtTags)
	{
		super.func_145839_a(nbtTags);
		
		autoMode = nbtTags.func_74767_n("autoMode");
		operatingTicks = nbtTags.func_74762_e("operatingTicks");
		controlType = RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
		pulseOperations = nbtTags.func_74762_e("pulseOperations");
		stockControl = nbtTags.func_74767_n("stockControl");
	}

	@Override
	public NBTTagCompound func_189515_b(NBTTagCompound nbtTags)
	{
		super.func_189515_b(nbtTags);

		nbtTags.func_74757_a("autoMode", autoMode);
		nbtTags.func_74768_a("operatingTicks", operatingTicks);
		nbtTags.func_74768_a("controlType", controlType.ordinal());
		nbtTags.func_74768_a("pulseOperations", pulseOperations);
		nbtTags.func_74757_a("stockControl", stockControl);
		
		return nbtTags;
	}
	
	@Override
	public void handlePacketData(ByteBuf dataStream)
	{
		if(FMLCommonHandler.instance().getEffectiveSide().isServer())
		{
			int type = dataStream.readInt();
			
			if(type == 0)
			{
				toggleAutoMode();
			}
			else if(type == 1)
			{
				encodeFormula();
			}
			else if(type == 2)
			{
				craftSingle();
			}
			else if(type == 3)
			{
				craftAll();
			}
			else if(type == 4)
			{
				if(formula != null)
				{
					moveItemsToGrid();
				}
				else {
					moveItemsToInput(true);
				}
			}
			else if(type == 5)
			{
				toggleStockControl();
			}
			
			return;
		}
		
		super.handlePacketData(dataStream);
		
		if(FMLCommonHandler.instance().getEffectiveSide().isClient())
		{
			autoMode = dataStream.readBoolean();
			operatingTicks = dataStream.readInt();
			controlType = RedstoneControl.values()[dataStream.readInt()];
			isRecipe = dataStream.readBoolean();
			stockControl = dataStream.readBoolean();
			
			if(dataStream.readBoolean())
			{
				if(dataStream.readBoolean())
				{
					NonNullList<ItemStack> inv = NonNullList.func_191197_a(9, ItemStack.field_190927_a);
					
					for(int i = 0; i < 9; i++)
					{
						if(dataStream.readBoolean())
						{
							inv.set(i, PacketHandler.readStack(dataStream));
						}
					}
					
					formula = new RecipeFormula(field_145850_b, inv);
				}
				else {
					formula = null;
				}
			}
		}
	}

	@Override
	public ArrayList getNetworkedData(ArrayList data)
	{
		super.getNetworkedData(data);
		
		data.add(autoMode);
		data.add(operatingTicks);
		data.add(controlType.ordinal());
		data.add(isRecipe);
		data.add(stockControl);
		
		if(needsFormulaUpdate)
		{
			data.add(true);
			
			if(formula != null)
			{
				data.add(true);
				
				for(int i = 0; i < 9; i++)
				{
					if(!formula.input.get(i).func_190926_b())
					{
						data.add(true);
						data.add(formula.input.get(i));
					}
					else {
						data.add(false);
					}
				}
			}
			else {
				data.add(false);
			}
		}
		else {
			data.add(false);
		}
		
		needsFormulaUpdate = false;
		
		return data;
	}
	
	@Override
	public RedstoneControl getControlType()
	{
		return controlType;
	}

	@Override
	public void setControlType(RedstoneControl type)
	{
		controlType = type;
		MekanismUtils.saveChunk(this);
	}

	@Override
	public boolean canPulse()
	{
		return true;
	}
	
	@Override
	public TileComponentConfig getConfig()
	{
		return configComponent;
	}

	@Override
	public EnumFacing getOrientation()
	{
		return facing;
	}
	
	@Override
	public TileComponentUpgrade getComponent()
	{
		return upgradeComponent;
	}
	
	@Override
	public TileComponentEjector getEjector()
	{
		return ejectorComponent;
	}
	
	@Override
	public TileComponentSecurity getSecurity()
	{
		return securityComponent;
	}
	
	@Override
	public void recalculateUpgradables(Upgrade upgrade)
	{
		super.recalculateUpgradables(upgrade);

		switch(upgrade)
		{
			case SPEED:
				ticksRequired = MekanismUtils.getTicks(this, BASE_TICKS_REQUIRED);
				energyPerTick = MekanismUtils.getEnergyPerTick(this, BASE_ENERGY_PER_TICK);
				break;
			case ENERGY:
				energyPerTick = MekanismUtils.getEnergyPerTick(this, BASE_ENERGY_PER_TICK);
				maxEnergy = MekanismUtils.getMaxEnergy(this, BASE_MAX_ENERGY);
				setEnergy(Math.min(getMaxEnergy(), getEnergy()));
				break;
			default:
				break;
		}
	}
	
	@Override
	public boolean hasCapability(Capability<?> capability, EnumFacing side)
	{
		return capability == Capabilities.CONFIG_CARD_CAPABILITY || super.hasCapability(capability, side);
	}

	@Override
	public <T> T getCapability(Capability<T> capability, EnumFacing side)
	{
		if(capability == Capabilities.CONFIG_CARD_CAPABILITY)
		{
			return (T)this;
		}
		
		return super.getCapability(capability, side);
	}
}
