package mekanism.common.tile;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import io.netty.buffer.ByteBuf;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;

import mekanism.api.Coord4D;
import mekanism.api.Range4D;
import mekanism.api.energy.EnergizedItemManager;
import mekanism.api.energy.IEnergizedItem;
import mekanism.common.Mekanism;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig.general;
import mekanism.common.entity.EntityRobit;
import mekanism.common.network.PacketTileEntity.TileEntityMessage;
import mekanism.common.tile.prefab.TileEntityNoisyBlock;
import mekanism.common.util.MekanismUtils;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import cofh.api.energy.IEnergyContainerItem;

public class TileEntityChargepad extends TileEntityNoisyBlock
{
	public boolean isActive;
	public boolean clientActive;

	public Random random = new Random();

	public TileEntityChargepad()
	{
		super("machine.chargepad", "Chargepad", BlockStateMachine.MachineType.CHARGEPAD.baseEnergy);
		inventory = NonNullList.func_191197_a(0, ItemStack.field_190927_a);
	}

	@Override
	public void onUpdate()
	{
		super.onUpdate();

		if(!field_145850_b.field_72995_K)
		{
			isActive = false;
			List<EntityLivingBase> entities = field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(func_174877_v().func_177958_n(), func_174877_v().func_177956_o(), func_174877_v().func_177952_p(), func_174877_v().func_177958_n() + 1, func_174877_v().func_177956_o() + 0.2, func_174877_v().func_177952_p() + 1));

			for(EntityLivingBase entity : entities)
			{
				if(entity instanceof EntityPlayer || entity instanceof EntityRobit)
				{
					isActive = true;
				}

				if(getEnergy() > 0)
				{
					if(entity instanceof EntityRobit)
					{
						EntityRobit robit = (EntityRobit) entity;

						double canGive = Math.min(getEnergy(), 1000);
						double toGive = Math.min(robit.MAX_ELECTRICITY - robit.getEnergy(), canGive);

						robit.setEnergy(robit.getEnergy() + toGive);
						setEnergy(getEnergy() - toGive);
					} 
					else if(entity instanceof EntityPlayer)
					{
						EntityPlayer player = (EntityPlayer) entity;

						double prevEnergy = getEnergy();

						for(ItemStack itemstack : player.field_71071_by.field_70460_b)
						{
							chargeItemStack(itemstack);

							if(prevEnergy != getEnergy())
							{
								break;
							}
						}

						for(ItemStack itemstack : player.field_71071_by.field_70462_a)
						{
							chargeItemStack(itemstack);

							if(prevEnergy != getEnergy())
							{
								break;
							}
						}
					}
				}
			}

			if(clientActive != isActive)
			{
				if(isActive)
				{
		            field_145850_b.func_184148_a((EntityPlayer)null, func_174877_v().func_177958_n() + 0.5, func_174877_v().func_177956_o() + 0.1, func_174877_v().func_177952_p() + 0.5, SoundEvents.field_187901_ga, SoundCategory.BLOCKS, 0.3F, 0.8F);
				}
				else {
		            field_145850_b.func_184148_a((EntityPlayer)null, func_174877_v().func_177958_n() + 0.5, func_174877_v().func_177956_o() + 0.1, func_174877_v().func_177952_p() + 0.5, SoundEvents.field_187847_fZ, SoundCategory.BLOCKS, 0.3F, 0.7F);
				}
				
				setActive(isActive);
			}
		}
		else if(isActive)
		{
			field_145850_b.func_175688_a(EnumParticleTypes.REDSTONE, func_174877_v().func_177958_n()+random.nextDouble(), func_174877_v().func_177956_o()+0.15, func_174877_v().func_177952_p()+random.nextDouble(), 0, 0, 0);
		}
	}

	public void chargeItemStack(ItemStack itemstack)
	{
		if(!itemstack.func_190926_b())
		{
			if(itemstack.func_77973_b() instanceof IEnergizedItem)
			{
				setEnergy(getEnergy() - EnergizedItemManager.charge(itemstack, getEnergy()));
			}
			else if(MekanismUtils.useTesla() && itemstack.hasCapability(Capabilities.TESLA_CONSUMER_CAPABILITY, null))
			{
				ITeslaConsumer consumer = itemstack.getCapability(Capabilities.TESLA_CONSUMER_CAPABILITY, null);
				
				long stored = (long)Math.round(getEnergy()*general.TO_TESLA);
				setEnergy(getEnergy() - consumer.givePower(stored, false)*general.FROM_TESLA);
			}
			else if(MekanismUtils.useForge() && itemstack.hasCapability(CapabilityEnergy.ENERGY, null))
			{
				IEnergyStorage storage = itemstack.getCapability(CapabilityEnergy.ENERGY, null);
				
				if(storage.canReceive())
				{
					int stored = (int)Math.round(Math.min(Integer.MAX_VALUE, getEnergy()*general.TO_FORGE));
					setEnergy(getEnergy() - storage.receiveEnergy(stored, false)*general.FROM_FORGE);
				}
			}
			else if(MekanismUtils.useRF() && itemstack.func_77973_b() instanceof IEnergyContainerItem)
			{
				IEnergyContainerItem item = (IEnergyContainerItem)itemstack.func_77973_b();

				int toTransfer = (int)Math.round(getEnergy()*general.TO_RF);
				setEnergy(getEnergy() - (item.receiveEnergy(itemstack, toTransfer, false)*general.FROM_RF));
			}
			else if(MekanismUtils.useIC2() && itemstack.func_77973_b() instanceof IElectricItem)
			{
				double sent = ElectricItem.manager.charge(itemstack, getEnergy()*general.TO_IC2, 4, true, false)*general.FROM_IC2;
				setEnergy(getEnergy() - sent);
			}
		}
	}

	@Override
	public boolean sideIsConsumer(EnumFacing side) 
	{
		return side == EnumFacing.DOWN || side == facing.func_176734_d();
	}

	@Override
	public boolean getActive()
	{
		return isActive;
	}

	@Override
	public void setActive(boolean active)
	{
		isActive = active;

		if(clientActive != active)
		{
			Mekanism.packetHandler.sendToReceivers(new TileEntityMessage(Coord4D.get(this), getNetworkedData(new ArrayList<Object>())), new Range4D(Coord4D.get(this)));
		}

		clientActive = active;
	}

	@Override
	public void func_145839_a(NBTTagCompound nbtTags)
	{
		super.func_145839_a(nbtTags);

		isActive = nbtTags.func_74767_n("isActive");
	}

	@Override
	public NBTTagCompound func_189515_b(NBTTagCompound nbtTags)
	{
		super.func_189515_b(nbtTags);

		nbtTags.func_74757_a("isActive", isActive);
		
		return nbtTags;
	}

	@Override
	public void handlePacketData(ByteBuf dataStream)
	{
		super.handlePacketData(dataStream);
		
		if(FMLCommonHandler.instance().getEffectiveSide().isClient())
		{
			clientActive = dataStream.readBoolean();
			
			if(clientActive != isActive)
			{
				isActive = clientActive;
				MekanismUtils.updateBlock(field_145850_b, func_174877_v());
			}
		}
	}

	@Override
	public ArrayList<Object> getNetworkedData(ArrayList<Object> data)
	{
		super.getNetworkedData(data);
		data.add(isActive);
		return data;
	}

	@Override
	public boolean canSetFacing(int side)
	{
		return side != 0 && side != 1;
	}

	@Override
	@SideOnly(Side.CLIENT)
	public float getVolume()
	{
		return 0.4F*super.getVolume();
	}

	@Override
	public boolean renderUpdate()
	{
		return false;
	}

	@Override
	public boolean lightUpdate()
	{
		return true;
	}
}
