package mekanism.common.tile;

import io.netty.buffer.ByteBuf;

import java.util.ArrayList;

import mekanism.api.Coord4D;
import mekanism.api.Range4D;
import mekanism.common.Mekanism;
import mekanism.common.base.ITileNetwork;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.network.PacketDataRequest.DataRequestMessage;
import mekanism.common.network.PacketTileEntity.TileEntityMessage;
import mekanism.common.tile.prefab.TileEntityBasicBlock;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;

public class TileEntityBoundingBlock extends TileEntity implements ITileNetwork
{
	public BlockPos mainPos = BlockPos.field_177992_a;
	
	public boolean receivedCoords;

	public int prevPower;

	public void setMainLocation(BlockPos pos)
	{
		receivedCoords = true;
		
		if(!field_145850_b.field_72995_K)
		{
			mainPos = pos;

			Mekanism.packetHandler.sendToReceivers(new TileEntityMessage(Coord4D.get(this), getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
		}
	}

	@Override
	public void func_145829_t()
	{
		super.func_145829_t();

		if(field_145850_b.field_72995_K)
		{
			Mekanism.packetHandler.sendToServer(new DataRequestMessage(Coord4D.get(this)));
		}
	}

	public void onNeighborChange(Block block)
	{
		TileEntity tile = field_145850_b.func_175625_s(mainPos);

		if(tile instanceof TileEntityBasicBlock)
		{
			TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)tile;

			int power = field_145850_b.func_175687_A(func_174877_v());

			if(prevPower != power)
			{
				if(power > 0)
				{
					onPower();
				}
				else {
					onNoPower();
				}

				prevPower = power;
				Mekanism.packetHandler.sendToReceivers(new TileEntityMessage(Coord4D.get(tileEntity), tileEntity.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
			}
		}
	}

	public void onPower() {}

	public void onNoPower() {}

	@Override
	public void handlePacketData(ByteBuf dataStream)
	{
		if(field_145850_b.field_72995_K)
		{
			mainPos = new BlockPos(dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
			prevPower = dataStream.readInt();
		}
	}

	@Override
	public void func_145839_a(NBTTagCompound nbtTags)
	{
		super.func_145839_a(nbtTags);

		mainPos = new BlockPos(nbtTags.func_74762_e("mainX"), nbtTags.func_74762_e("mainY"), nbtTags.func_74762_e("mainZ"));
		prevPower = nbtTags.func_74762_e("prevPower");
		receivedCoords = nbtTags.func_74767_n("receivedCoords");
	}

	@Override
	public NBTTagCompound func_189515_b(NBTTagCompound nbtTags)
	{
		super.func_189515_b(nbtTags);

		nbtTags.func_74768_a("mainX", mainPos.func_177958_n());
		nbtTags.func_74768_a("mainY", mainPos.func_177956_o());
		nbtTags.func_74768_a("mainZ", mainPos.func_177952_p());
		nbtTags.func_74768_a("prevPower", prevPower);
		nbtTags.func_74757_a("receivedCoords", receivedCoords);
		
		return nbtTags;
	}

	@Override
	public ArrayList<Object> getNetworkedData(ArrayList<Object> data)
	{
		data.add(mainPos.func_177958_n());
		data.add(mainPos.func_177956_o());
		data.add(mainPos.func_177952_p());
		data.add(prevPower);

		return data;
	}
	
	@Override
	public boolean hasCapability(Capability<?> capability, EnumFacing facing)
	{
		return capability == Capabilities.TILE_NETWORK_CAPABILITY || super.hasCapability(capability, facing);
	}

	@Override
	public <T> T getCapability(Capability<T> capability, EnumFacing facing)
	{
		if(capability == Capabilities.TILE_NETWORK_CAPABILITY)
		{
			return (T)this;
		}
		
		return super.getCapability(capability, facing);
	}
}
