package mekanism.common.tile;

import io.netty.buffer.ByteBuf;

import java.util.ArrayList;

import mekanism.api.Coord4D;
import mekanism.api.IConfigurable;
import mekanism.api.Range4D;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.Tier.BaseTier;
import mekanism.common.Tier.BinTier;
import mekanism.common.base.IActiveState;
import mekanism.common.base.ILogisticalTransporter;
import mekanism.common.base.ITierUpgradeable;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.transporter.TransitRequest;
import mekanism.common.content.transporter.TransitRequest.TransitResponse;
import mekanism.common.item.ItemBlockBasic;
import mekanism.common.network.PacketTileEntity.TileEntityMessage;
import mekanism.common.tile.prefab.TileEntityBasicBlock;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional.Interface;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityBin extends TileEntityBasicBlock implements ISidedInventory, IActiveState, IConfigurable, ITierUpgradeable
{
	public boolean isActive;

	public boolean clientActive;

	public final int MAX_DELAY = 10;

	public int addTicks = 0;

	public int delayTicks;

	public int cacheCount;
	
	public BinTier tier = BinTier.BASIC;

	public ItemStack itemType = ItemStack.field_190927_a;

	public ItemStack topStack = ItemStack.field_190927_a;
	public ItemStack bottomStack = ItemStack.field_190927_a;

	public int prevCount;

	public int clientAmount;

	private BinItemHandler myItemHandler;

	public TileEntityBin()
	{
		myItemHandler = new BinItemHandler(this);
	}
	
	@Override
	public boolean upgrade(BaseTier upgradeTier)
	{
		if(upgradeTier.ordinal() != tier.ordinal()+1)
		{
			return false;
		}
		
		tier = BinTier.values()[upgradeTier.ordinal()];
		
		Mekanism.packetHandler.sendToReceivers(new TileEntityMessage(Coord4D.get(this), getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
		func_70296_d();
		
		return true;
	}

	public void sortStacks()
	{
		if(getItemCount() == 0 || itemType.func_190926_b())
		{
			itemType = ItemStack.field_190927_a;
			topStack = ItemStack.field_190927_a;
			bottomStack = ItemStack.field_190927_a;
			cacheCount = 0;

			return;
		}

		int count = getItemCount();
		int remain = tier.storage-count;

		if(remain >= itemType.func_77976_d())
		{
			topStack = ItemStack.field_190927_a;
		}
		else {
			topStack = itemType.func_77946_l();
			topStack.func_190920_e(itemType.func_77976_d()-remain);
		}

		count -= StackUtils.getSize(topStack);

		bottomStack = itemType.func_77946_l();
		bottomStack.func_190920_e(Math.min(itemType.func_77976_d(), count));

		count -= StackUtils.getSize(bottomStack);

		cacheCount = count;
	}

	public boolean isValid(ItemStack stack)
	{
		if(stack.func_190926_b() || stack.func_190916_E() <= 0)
		{
			return false;
		}

		if(stack.func_77973_b() instanceof ItemBlockBasic && stack.func_77952_i() == 6)
		{
			return false;
		}

		if(itemType.func_190926_b())
		{
			return true;
		}

		if(!stack.func_77969_a(itemType) || !ItemStack.func_77970_a(stack, itemType))
		{
			return false;
		}

		return true;
	}

	public ItemStack add(ItemStack stack, boolean simulate)
	{
		if(isValid(stack) && (tier == BinTier.CREATIVE || getItemCount() != tier.storage))
		{
			if(itemType.func_190926_b() && !simulate)
			{
				setItemType(stack);
			}

			if(tier != BinTier.CREATIVE)
			{
				if(getItemCount() + stack.func_190916_E() <= tier.storage)
				{
					if(!simulate)
					{
						setItemCount(getItemCount() + stack.func_190916_E());
					}
					
					return ItemStack.field_190927_a;
				}
				else {
					ItemStack rejects = stack.func_77946_l();
					rejects.func_190920_e((getItemCount()+stack.func_190916_E()) - tier.storage);

					if(!simulate)
					{
						setItemCount(tier.storage);
					}
	
					return rejects;
				}
			}
			else {
				if(!simulate)
				{
					setItemCount(Integer.MAX_VALUE);
				}
			}
		}

		return stack;
	}

	public ItemStack add(ItemStack stack)
	{
		return add(stack, false);
	}

	public ItemStack removeStack()
	{
		if(getItemCount() == 0)
		{
			return ItemStack.field_190927_a;
		}

		return remove(bottomStack.func_190916_E());
	}

	public ItemStack remove(int amount, boolean simulate)
	{
		if(getItemCount() == 0)
		{
			return ItemStack.field_190927_a;
		}

		ItemStack ret = itemType.func_77946_l();
		ret.func_190920_e(Math.min(Math.min(amount, itemType.func_77976_d()), getItemCount()));
		
		if(tier != BinTier.CREATIVE && !simulate)
		{
			setItemCount(getItemCount() - ret.func_190916_E());
		}

		return ret;
	}

	public ItemStack remove(int amount)
	{
		return remove(amount, false);
	}

	public int getItemCount()
	{
		return StackUtils.getSize(bottomStack) + cacheCount + StackUtils.getSize(topStack);
	}

	@Override
	public void onUpdate()
	{
		if(!field_145850_b.field_72995_K)
		{
			addTicks = Math.max(0, addTicks-1);
			delayTicks = Math.max(0, delayTicks-1);

			sortStacks();

			if(getItemCount() != prevCount)
			{
				func_70296_d();
				MekanismUtils.saveChunk(this);
			}

			if(delayTicks == 0)
			{
				if(!bottomStack.func_190926_b() && isActive)
				{
					TileEntity tile = Coord4D.get(this).offset(EnumFacing.DOWN).getTileEntity(field_145850_b);

					if(CapabilityUtils.hasCapability(tile, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, EnumFacing.UP))
					{
						ILogisticalTransporter transporter = CapabilityUtils.getCapability(tile, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, EnumFacing.UP);
						TransitResponse response = TransporterUtils.insert(this, transporter, TransitRequest.getFromStack(bottomStack), null, true, 0);

						if(!response.isEmpty())
						{
							bottomStack.func_190918_g(response.stack.func_190916_E());
							func_70299_a(0, bottomStack);
						}
					}
					else {
						TransitResponse response = InventoryUtils.putStackInInventory(tile, TransitRequest.getFromStack(bottomStack), EnumFacing.DOWN, false);
						
						if(!response.isEmpty())
						{
							bottomStack.func_190918_g(response.stack.func_190916_E());
							func_70299_a(0, bottomStack);
						}
					}

					delayTicks = 10;
				}
			}
			else {
				delayTicks--;
			}
		}
	}

	@Override
	public NBTTagCompound func_189515_b(NBTTagCompound nbtTags)
	{
		super.func_189515_b(nbtTags);

		nbtTags.func_74757_a("isActive", isActive);
		nbtTags.func_74768_a("itemCount", cacheCount);
		nbtTags.func_74768_a("tier", tier.ordinal());

		if(!bottomStack.func_190926_b())
		{
			nbtTags.func_74782_a("bottomStack", bottomStack.func_77955_b(new NBTTagCompound()));
		}

		if(!topStack.func_190926_b())
		{
			nbtTags.func_74782_a("topStack", topStack.func_77955_b(new NBTTagCompound()));
		}

		if(getItemCount() > 0)
		{
			nbtTags.func_74782_a("itemType", itemType.func_77955_b(new NBTTagCompound()));
		}
		
		return nbtTags;
	}

	@Override
	public void func_145839_a(NBTTagCompound nbtTags)
	{
		super.func_145839_a(nbtTags);

		isActive = nbtTags.func_74767_n("isActive");
		cacheCount = nbtTags.func_74762_e("itemCount");
		tier = BinTier.values()[nbtTags.func_74762_e("tier")];

		bottomStack = InventoryUtils.loadFromNBT(nbtTags.func_74775_l("bottomStack"));
		topStack = InventoryUtils.loadFromNBT(nbtTags.func_74775_l("topStack"));

		if(getItemCount() > 0)
		{
			itemType = InventoryUtils.loadFromNBT(nbtTags.func_74775_l("itemType"));
		}
	}

	@Override
	public ArrayList<Object> getNetworkedData(ArrayList<Object> data)
	{
		super.getNetworkedData(data);

		data.add(isActive);
		data.add(getItemCount());
		data.add(tier.ordinal());

		if(getItemCount() > 0)
		{
			data.add(itemType);
		}

		return data;
	}

	@Override
	public void handlePacketData(ByteBuf dataStream)
	{
		super.handlePacketData(dataStream);

		if(FMLCommonHandler.instance().getEffectiveSide().isClient())
		{
			isActive = dataStream.readBoolean();
			clientAmount = dataStream.readInt();
			tier = BinTier.values()[dataStream.readInt()];
	
			if(clientAmount > 0)
			{
				itemType = PacketHandler.readStack(dataStream);
			}
			else {
				itemType = ItemStack.field_190927_a;
			}
	
			MekanismUtils.updateBlock(field_145850_b, func_174877_v());
		}
	}

	@Override
	public ItemStack func_70301_a(int slotID)
	{
		if(slotID == 1)
		{
			return topStack;
		}
		else {
			return bottomStack;
		}
	}

	@Override
	public ItemStack func_70298_a(int slotID, int amount)
	{
		if(slotID == 1)
		{
			return ItemStack.field_190927_a;
		}
		else if(slotID == 0)
		{
			int toRemove = Math.min(getItemCount(), amount);

			if(toRemove > 0)
			{
				ItemStack ret = itemType.func_77946_l();
				ret.func_190920_e(toRemove);

				setItemCount(getItemCount()-toRemove);

				return ret;
			}
		}

		return ItemStack.field_190927_a;
	}

	@Override
	public ItemStack func_70304_b(int slotID)
	{
		return func_70301_a(slotID);
	}

	@Override
	public int func_70302_i_()
	{
		return 2;
	}

	@Override
	public void func_70299_a(int i, ItemStack itemstack)
	{
		if(i == 0)
		{
			if(getItemCount() == 0)
			{
				return;
			}

			if(tier != BinTier.CREATIVE)
			{
				if(itemstack.func_190926_b())
				{
					setItemCount(getItemCount() - bottomStack.func_190916_E());
				}
				else {
					setItemCount(getItemCount() - (bottomStack.func_190916_E()-itemstack.func_190916_E()));
				}
			}
		}
		else if(i == 1)
		{
			if(itemstack.func_190926_b())
			{
				topStack = ItemStack.field_190927_a;
			}
			else {
				if(isValid(itemstack) && itemstack.func_190916_E() > StackUtils.getSize(topStack) && tier != BinTier.CREATIVE)
				{
					add(StackUtils.size(itemstack, itemstack.func_190916_E()-StackUtils.getSize(topStack)));
				}
			}
		}
	}

	@Override
	public void func_70296_d()
	{
		super.func_70296_d();

		if(!field_145850_b.field_72995_K)
		{
			MekanismUtils.saveChunk(this);
			Mekanism.packetHandler.sendToReceivers(new TileEntityMessage(Coord4D.get(this), getNetworkedData(new ArrayList<Object>())), new Range4D(Coord4D.get(this)));
			prevCount = getItemCount();
			sortStacks();
		}
	}

	public void setItemType(ItemStack stack)
	{
		if(stack.func_190926_b())
		{
			itemType = ItemStack.field_190927_a;
			cacheCount = 0;
			topStack = ItemStack.field_190927_a;
			bottomStack = ItemStack.field_190927_a;
			return;
		}

		ItemStack ret = stack.func_77946_l();
		ret.func_190920_e(1);
		itemType = ret;
	}

	public void setItemCount(int count)
	{
		cacheCount = Math.max(0, count);
		topStack = ItemStack.field_190927_a;
		bottomStack = ItemStack.field_190927_a;

		if(count == 0)
		{
			setItemType(ItemStack.field_190927_a);
		}

		func_70296_d();
	}

	@Override
	public String func_70005_c_()
	{
		return LangUtils.localize(func_145838_q().func_149739_a() + ".Bin" + tier.getBaseTier().getSimpleName() + ".name");
	}

	@Override
	public boolean func_145818_k_()
	{
		return true;
	}

	@Override
	public ITextComponent func_145748_c_()
	{
		return new TextComponentString(func_70005_c_());
	}

	@Override
	public int func_70297_j_()
	{
		return 64;
	}

	@Override
	public boolean func_70300_a(EntityPlayer entityplayer)
	{
		return true;
	}

	@Override
	public void func_174889_b(EntityPlayer player) {}

	@Override
	public void func_174886_c(EntityPlayer player) {}

	@Override
	public boolean func_94041_b(int i, ItemStack itemstack)
	{
		return i == 1 && isValid(itemstack);
	}
	
	@Override
	public boolean func_191420_l()
	{
		return getItemCount() == 0;
	}

	@Override
	public int func_174887_a_(int id)
	{
		return 0;
	}

	@Override
	public void func_174885_b(int id, int value)
	{

	}

	@Override
	public int func_174890_g()
	{
		return 0;
	}

	@Override
	public void func_174888_l() {}

	@Override
	public int[] func_180463_a(EnumFacing side)
	{
		if(side == EnumFacing.UP)
		{
			return new int[] {1};
		}
		else if(side == EnumFacing.DOWN)
		{
			return new int[] {0};
		}

		return InventoryUtils.EMPTY;
	}

	@Override
	public boolean func_180462_a(int i, ItemStack itemstack, EnumFacing side)
	{
		return func_94041_b(i, itemstack);
	}

	@Override
	public boolean func_180461_b(int i, ItemStack itemstack, EnumFacing side)
	{
		return i == 0 && isValid(itemstack);
	}

	@Override
	public boolean canSetFacing(int facing)
	{
		return facing != 0 && facing != 1;
	}

	@Override
	public void setActive(boolean active)
	{
		isActive = active;

		if(clientActive != active)
		{
			Mekanism.packetHandler.sendToReceivers(new TileEntityMessage(Coord4D.get(this), getNetworkedData(new ArrayList<Object>())), new Range4D(Coord4D.get(this)));

			clientActive = active;
		}
	}

	@Override
	public boolean getActive()
	{
		return isActive;
	}

	@Override
	public boolean renderUpdate()
	{
		return true;
	}

	@Override
	public boolean lightUpdate()
	{
		return true;
	}

//	@Override
//	public ItemStack getStoredItemType()
//	{
//		if(itemType == null)
//		{
//			return ItemStack.EMPTY;
//		}
//
//		return MekanismUtils.size(itemType, getItemCount());
//	}
//
//	@Override
//	public void setStoredItemCount(int amount)
//	{
//		if(amount == 0)
//		{
//			setStoredItemType(ItemStack.EMPTY, 0);
//		}
//
//		setItemCount(amount);
//	}
//
//	@Override
//	public void setStoredItemType(ItemStack type, int amount)
//	{
//		itemType = type;
//		cacheCount = amount;
//
//		topStack = ItemStack.EMPTY;
//		bottomStack = ItemStack.EMPTY;
//
//		markDirty();
//	}
//
//	@Override
	public int getMaxStoredCount()
	{
		return tier.storage;
	}

	@Override
	public EnumActionResult onSneakRightClick(EntityPlayer player, EnumFacing side)
	{
		setActive(!getActive());
		field_145850_b.func_184148_a(null, func_174877_v().func_177958_n(), func_174877_v().func_177956_o(), func_174877_v().func_177952_p(), SoundEvents.field_187909_gi, SoundCategory.BLOCKS, 0.3F, 1);
		
		return EnumActionResult.SUCCESS;
	}

	@Override
	public EnumActionResult onRightClick(EntityPlayer player, EnumFacing side)
	{
		return EnumActionResult.PASS;
	}
	
	@Override
	public boolean hasCapability(Capability<?> capability, EnumFacing side)
	{
		return capability == Capabilities.CONFIGURABLE_CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, side);
	}

	@Override
	public <T> T getCapability(Capability<T> capability, EnumFacing side)
	{
		if(capability == Capabilities.CONFIGURABLE_CAPABILITY)
		{
			return (T)this;
		}
		else if(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)
		{
			return (T)myItemHandler;
		}
		
		return super.getCapability(capability, side);
	}

	private class BinItemHandler implements IItemHandler
	{
		private TileEntityBin tileEntityBin;

		public BinItemHandler(TileEntityBin tileEntityBin)
		{
			this.tileEntityBin = tileEntityBin;
		}
		
		@Override
		public int getSlotLimit(int slot)
		{
			if(slot != 0)
			{
				return 0;
			}
			
			return tier.storage;
		}

		@Override
		public int getSlots()
		{
			return 1;
		}

		@Override
		public ItemStack getStackInSlot(int slot)
		{
			if(slot != 0 || tileEntityBin.itemType.func_190926_b())
			{
				return ItemStack.field_190927_a;
			}

			return MekanismUtils.size(tileEntityBin.itemType, tileEntityBin.getItemCount());
		}

		@Override
		public ItemStack insertItem(int slot, ItemStack stack, boolean simulate)
		{
			if(slot != 0)
			{
				return ItemStack.field_190927_a;
			}
			
			return tileEntityBin.add(stack, simulate);
		}

		public ItemStack extractItem(int slot, int amount, boolean simulate)
		{
			if(slot != 0)
			{
				return ItemStack.field_190927_a;
			}

			return tileEntityBin.remove(amount, simulate);
		}
	}
}
