package mekanism.common.tile;

import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import mekanism.api.Coord4D;
import mekanism.api.IConfigCardAccess.ISpecialConfigData;
import mekanism.api.energy.IStrictEnergyAcceptor;
import mekanism.common.base.IAdvancedBoundingBlock;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.integration.MekanismHooks;
import mekanism.common.integration.computer.IComputerIntegration;
import mekanism.common.util.InventoryUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Optional.Interface;
import net.minecraftforge.fml.common.Optional.InterfaceList;
import net.minecraftforge.fml.common.Optional.Method;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;

@InterfaceList({
	@Interface(iface = "ic2.api.energy.tile.IEnergySink", modid = MekanismHooks.IC2_MOD_ID)
})
public class TileEntityAdvancedBoundingBlock extends TileEntityBoundingBlock implements ISidedInventory, IEnergySink, IStrictEnergyAcceptor, IEnergyReceiver, IEnergyProvider, IComputerIntegration, ISpecialConfigData
{
	@Override
	public boolean func_191420_l()
	{
		IAdvancedBoundingBlock inv = getInv();
		if(inv == null)
		{
			return true;
		}
		
		return inv.func_191420_l();
	}
	
	@Override
	public int func_70302_i_()
	{
		IAdvancedBoundingBlock inv = getInv();
		if(inv == null)
		{
			return 0;
		}

		return inv.func_70302_i_();
	}

	@Override
	public ItemStack func_70301_a(int i)
	{
		IAdvancedBoundingBlock inv = getInv();
		if(inv == null)
		{
			return ItemStack.field_190927_a;
		}

		return inv.func_70301_a(i);
	}

	@Override
	public ItemStack func_70298_a(int i, int j)
	{
		IAdvancedBoundingBlock inv = getInv();
		if(inv == null)
		{
			return ItemStack.field_190927_a;
		}

		return inv.func_70298_a(i, j);
	}

	@Override
	public ItemStack func_70304_b(int i)
	{
		IAdvancedBoundingBlock inv = getInv();
		if(inv == null)
		{
			return ItemStack.field_190927_a;
		}

		return inv.func_70304_b(i);
	}

	@Override
	public void func_70299_a(int i, ItemStack itemstack)
	{
		IAdvancedBoundingBlock inv = getInv();
		if(inv == null)
		{
			return;
		}

		inv.func_70299_a(i, itemstack);
	}

	@Override
	public String func_70005_c_()
	{
		IAdvancedBoundingBlock inv = getInv();
		if(inv == null)
		{
			return "null";
		}

		return inv.func_70005_c_();
	}

	@Override
	public boolean func_145818_k_()
	{
		IAdvancedBoundingBlock inv = getInv();
		if(inv == null)
		{
			return false;
		}

		return inv.func_145818_k_();
	}

	@Override
	public ITextComponent func_145748_c_()
	{
		return new TextComponentString(func_70005_c_());
	}

	@Override
	public int func_70297_j_()
	{
		IAdvancedBoundingBlock inv = getInv();
		if(inv == null)
		{
			return 0;
		}

		return inv.func_70297_j_();
	}

	@Override
	public boolean func_70300_a(EntityPlayer entityplayer)
	{
		IAdvancedBoundingBlock inv = getInv();
		if(inv == null)
		{
			return false;
		}

		return inv.func_70300_a(entityplayer);
	}

	@Override
	public void func_174889_b(EntityPlayer player)
	{
		IAdvancedBoundingBlock inv = getInv();
		if(inv == null)
		{
			return;
		}

		inv.func_174889_b(player);
	}

	@Override
	public void func_174886_c(EntityPlayer player)
	{
		IAdvancedBoundingBlock inv = getInv();
		if(inv == null)
		{
			return;
		}

		inv.func_174886_c(player);
	}

	@Override
	public boolean func_94041_b(int i, ItemStack itemstack)
	{
		IAdvancedBoundingBlock inv = getInv();
		if(inv == null)
		{
			return false;
		}

		return inv.canBoundInsert(func_174877_v(), i, itemstack);
	}

	@Override
	public int func_174887_a_(int id)
	{
		return 0;
	}

	@Override
	public void func_174885_b(int id, int value)
	{

	}

	@Override
	public int func_174890_g()
	{
		return 0;
	}

	@Override
	public void func_174888_l() {}

	@Override
	public int[] func_180463_a(EnumFacing side)
	{
		IAdvancedBoundingBlock inv = getInv();
		if(inv == null)
		{
			return InventoryUtils.EMPTY;
		}

		return inv.getBoundSlots(func_174877_v(), side);
	}

	@Override
	public boolean func_180462_a(int i, ItemStack itemstack, EnumFacing side)
	{
		return func_94041_b(i, itemstack);
	}

	@Override
	public boolean func_180461_b(int i, ItemStack itemstack, EnumFacing side)
	{
		IAdvancedBoundingBlock inv = getInv();
		if(inv == null)
		{
			return false;
		}

		return inv.canBoundExtract(func_174877_v(), i, itemstack, side);
	}

	@Override
	@Method(modid = MekanismHooks.IC2_MOD_ID)
	public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing direction)
	{
		IAdvancedBoundingBlock inv = getInv();
		if(inv == null)
		{
			return false;
		}

		return inv.acceptsEnergyFrom(emitter, direction);
	}

	@Override
	public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate)
	{
		IAdvancedBoundingBlock inv = getInv();
		if(inv == null || !canReceiveEnergy(from))
		{
			return 0;
		}

		return inv.receiveEnergy(from, maxReceive, simulate);
	}

	@Override
	public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate)
	{
		IAdvancedBoundingBlock inv = getInv();
		if(inv == null)
		{
			return 0;
		}

		return inv.extractEnergy(from, maxExtract, simulate);
	}

	@Override
	public boolean canConnectEnergy(EnumFacing from)
	{
		return canReceiveEnergy(from);
	}

	@Override
	public int getEnergyStored(EnumFacing from)
	{
		IAdvancedBoundingBlock inv = getInv();
		if(inv == null)
		{
			return 0;
		}

		return inv.getEnergyStored(from);
	}

	@Override
	public int getMaxEnergyStored(EnumFacing from)
	{
		IAdvancedBoundingBlock inv = getInv();
		if(inv == null)
		{
			return 0;
		}

		return inv.getMaxEnergyStored(from);
	}

	@Override
	public double acceptEnergy(EnumFacing side, double amount, boolean simulate)
	{
		IAdvancedBoundingBlock inv = getInv();
		if(inv == null || !canReceiveEnergy(side))
		{
			return 0;
		}

		return inv.acceptEnergy(side, amount, simulate);
	}

	@Override
	public boolean canReceiveEnergy(EnumFacing side)
	{
		IAdvancedBoundingBlock inv = getInv();
		if(inv == null)
		{
			return false;
		}

		return inv.canBoundReceiveEnergy(func_174877_v(), side);
	}

	@Override
	@Method(modid = MekanismHooks.IC2_MOD_ID)
	public double getDemandedEnergy()
	{
		IAdvancedBoundingBlock inv = getInv();
		return inv == null ? 0 : inv.getDemandedEnergy();
	}

	@Override
	@Method(modid = MekanismHooks.IC2_MOD_ID)
	public double injectEnergy(EnumFacing directionFrom, double amount, double voltage)
	{
		IAdvancedBoundingBlock inv = getInv();
		if(inv == null || !canReceiveEnergy(directionFrom))
		{
			return amount;
		}

		return inv.injectEnergy(directionFrom, amount, voltage);
	}

	@Override
	@Method(modid = MekanismHooks.IC2_MOD_ID)
	public int getSinkTier()
	{
		IAdvancedBoundingBlock inv = getInv();
		if(inv == null)
		{
			return 0;
		}

		return inv.getSinkTier();
	}

	public IAdvancedBoundingBlock getInv()
	{
		if(!receivedCoords)
		{
			return null;
		}
		
		TileEntity tile = new Coord4D(mainPos, field_145850_b).getTileEntity(field_145850_b);

		if(!(tile instanceof IAdvancedBoundingBlock))
		{
			field_145850_b.func_175698_g(mainPos);
			return null;
		}

		return (IAdvancedBoundingBlock) tile;
	}

	@Override
	public void onPower()
	{
		super.onPower();

		IAdvancedBoundingBlock inv = getInv();
		if(inv != null)
		{
			inv.onPower();
		}
	}

	@Override
	public void onNoPower()
	{
		super.onNoPower();

		IAdvancedBoundingBlock inv = getInv();
		if(inv != null)
		{
			inv.onNoPower();
		}
	}

	@Override
	public String[] getMethods()
	{
		IAdvancedBoundingBlock inv = getInv();
		if(inv == null)
		{
			return new String[] {};
		}

		return inv.getMethods();
	}

	@Override
	public Object[] invoke(int method, Object[] arguments) throws Exception
	{
		IAdvancedBoundingBlock inv = getInv();
		if(inv == null)
		{
			return new Object[] {};
		}

		return inv.invoke(method, arguments);
	}

	@Override
	public NBTTagCompound getConfigurationData(NBTTagCompound nbtTags)
	{
		IAdvancedBoundingBlock inv = getInv();
		if(inv == null)
		{
			return new NBTTagCompound();
		}
		
		return inv.getConfigurationData(nbtTags);
	}

	@Override
	public void setConfigurationData(NBTTagCompound nbtTags)
	{
		IAdvancedBoundingBlock inv = getInv();
		if(inv == null)
		{
			return;
		}
		
		inv.setConfigurationData(nbtTags);
	}

	@Override
	public String getDataType()
	{
		IAdvancedBoundingBlock inv = getInv();
		if(inv == null)
		{
			return "null";
		}
		
		return inv.getDataType();
	}

	@Override
	public boolean hasCapability(Capability<?> capability, EnumFacing facing)
	{
		if (capability == Capabilities.TILE_NETWORK_CAPABILITY)
		{
			return super.hasCapability(capability, facing);
		}

		IAdvancedBoundingBlock inv = getInv();
		if(inv == null)
		{
			return super.hasCapability(capability, facing);
		}
		
		return inv.hasCapability(capability, facing);
	}

	@Override
	public <T> T getCapability(Capability<T> capability, EnumFacing facing)
	{
		if (capability == Capabilities.TILE_NETWORK_CAPABILITY)
		{
			return super.getCapability(capability, facing);
		}

		IAdvancedBoundingBlock inv = getInv();
		if(inv == null)
		{
			return super.getCapability(capability, facing);
		}
		
		return inv.getCapability(capability, facing);
	}
}
