package mekanism.common.security;

import io.netty.buffer.ByteBuf;

import java.util.ArrayList;
import java.util.UUID;

import mekanism.common.HashList;
import mekanism.common.PacketHandler;
import mekanism.common.frequency.Frequency;
import mekanism.common.security.ISecurityTile.SecurityMode;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.common.util.Constants.NBT;

public class SecurityFrequency extends Frequency
{
	public static final String SECURITY = "Security";
	
	public boolean override;
	
	public HashList<String> trusted;
	
	public SecurityMode securityMode;
	
	public SecurityFrequency(UUID uuid)
	{
		super("Security", uuid);
		
		trusted = new HashList<String>();
		securityMode = SecurityMode.PUBLIC;
	}
	
	public SecurityFrequency(NBTTagCompound nbtTags)
	{
		super(nbtTags);
	}
	
	public SecurityFrequency(ByteBuf dataStream)
	{
		super(dataStream);
	}
	
	@Override
	public void write(NBTTagCompound nbtTags)
	{
		super.write(nbtTags);
		
		nbtTags.func_74757_a("override", override);
		nbtTags.func_74768_a("securityMode", securityMode.ordinal());
		
		if(!trusted.isEmpty())
		{
			NBTTagList trustedList = new NBTTagList();
			
			for(String s : trusted)
			{
				trustedList.func_74742_a(new NBTTagString(s));
			}
			
			nbtTags.func_74782_a("trusted", trustedList);
		}
	}

	@Override
	protected void read(NBTTagCompound nbtTags)
	{
		super.read(nbtTags);
		
		trusted = new HashList<String>();
		securityMode = SecurityMode.PUBLIC;
		
		override = nbtTags.func_74767_n("override");
		securityMode = SecurityMode.values()[nbtTags.func_74762_e("securityMode")];
		
		if(nbtTags.func_74764_b("trusted"))
		{
			NBTTagList trustedList = nbtTags.func_150295_c("trusted", NBT.TAG_STRING);
			
			for(int i = 0; i < trustedList.func_74745_c(); i++)
			{
				trusted.add(trustedList.func_150307_f(i));
			}
		}
	}

	@Override
	public void write(ArrayList data)
	{
		super.write(data);
		
		data.add(override);
		data.add(securityMode.ordinal());
		
		data.add(trusted.size());
		
		for(String s : trusted)
		{
			data.add(s);
		}
	}

	@Override
	protected void read(ByteBuf dataStream)
	{
		super.read(dataStream);
		
		trusted = new HashList<String>();
		securityMode = SecurityMode.PUBLIC;
		
		override = dataStream.readBoolean();
		securityMode = SecurityMode.values()[dataStream.readInt()];
		
		int size = dataStream.readInt();
		
		for(int i = 0; i < size; i++)
		{
			trusted.add(PacketHandler.readString(dataStream));
		}
	}
}
