package mekanism.common.recipe.outputs;

import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.common.util.InventoryUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;

public class PressurizedOutput extends MachineOutput<PressurizedOutput>
{
	private ItemStack itemOutput = ItemStack.field_190927_a;
	private GasStack gasOutput;

	public PressurizedOutput(ItemStack item, GasStack gas)
	{
		itemOutput = item;
		gasOutput = gas;
	}
	
	public PressurizedOutput() {}
	
	@Override
	public void load(NBTTagCompound nbtTags)
	{
		itemOutput = InventoryUtils.loadFromNBT(nbtTags.func_74775_l("itemOutput"));
		gasOutput = GasStack.readFromNBT(nbtTags.func_74775_l("gasOutput"));
	}

	public boolean canFillTank(GasTank tank)
	{
		return tank.canReceive(gasOutput.getGas()) && tank.getNeeded() >= gasOutput.amount;
	}

	public boolean canAddProducts(NonNullList<ItemStack> inventory, int index)
	{
		return inventory.get(index).func_190926_b() || (inventory.get(index).func_77969_a(itemOutput) && inventory.get(index).func_190916_E() + itemOutput.func_190916_E() <= inventory.get(index).func_77976_d());
	}

	public void fillTank(GasTank tank)
	{
		tank.receive(gasOutput, true);
	}

	public void addProducts(NonNullList<ItemStack> inventory, int index)
	{
		if(inventory.get(index).func_190926_b())
		{
			inventory.set(index, itemOutput.func_77946_l());
		}
		else if(inventory.get(index).func_77969_a(itemOutput))
		{
			inventory.get(index).func_190917_f(itemOutput.func_190916_E());
		}
	}

	public boolean applyOutputs(NonNullList<ItemStack> inventory, int index, GasTank tank, boolean doEmit)
	{
		if(canFillTank(tank) && canAddProducts(inventory, index))
		{
			if(doEmit)
			{
				fillTank(tank);
				addProducts(inventory, index);
			}
			
			return true;
		}
		
		return false;
	}

	public ItemStack getItemOutput()
	{
		return itemOutput;
	}

	public GasStack getGasOutput()
	{
		return gasOutput;
	}

	@Override
	public PressurizedOutput copy()
	{
		return new PressurizedOutput(itemOutput.func_77946_l(), gasOutput.copy());
	}
}
