package mekanism.common.recipe.outputs;

import mekanism.common.util.InventoryUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;

public class ItemStackOutput extends MachineOutput<ItemStackOutput>
{
	public ItemStack output = ItemStack.field_190927_a;

	public ItemStackOutput(ItemStack stack)
	{
		output = stack;
	}
	
	public ItemStackOutput() {}
	
	@Override
	public void load(NBTTagCompound nbtTags)
	{
		output = InventoryUtils.loadFromNBT(nbtTags.func_74775_l("output"));
	}

	public boolean applyOutputs(NonNullList<ItemStack> inventory, int index, boolean doEmit)
	{
		if(inventory.get(index).func_190926_b())
		{
			if(doEmit)
			{
				inventory.set(index, output.func_77946_l());
			}
			
			return true;
		} 
		else if(inventory.get(index).func_77969_a(output) && inventory.get(index).func_190916_E() + output.func_190916_E() <= inventory.get(index).func_77976_d())
		{
			if(doEmit)
			{
				inventory.get(index).func_190917_f(output.func_190916_E());
			}
			
			return true;
		}
		
		return false;
	}

	@Override
	public ItemStackOutput copy()
	{
		return new ItemStackOutput(output.func_77946_l());
	}
}
