package mekanism.common.recipe.outputs;

import java.util.Random;

import mekanism.common.util.InventoryUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;

public class ChanceOutput extends MachineOutput<ChanceOutput>
{
	private static Random rand = new Random();

	public ItemStack primaryOutput = ItemStack.field_190927_a;

	public ItemStack secondaryOutput = ItemStack.field_190927_a;

	public double secondaryChance;

	public ChanceOutput(ItemStack primary, ItemStack secondary, double chance)
	{
		primaryOutput = primary;
		secondaryOutput = secondary;
		secondaryChance = chance;
	}
	
	public ChanceOutput() {}
	
	@Override
	public void load(NBTTagCompound nbtTags)
	{
		primaryOutput = InventoryUtils.loadFromNBT(nbtTags.func_74775_l("primaryOutput"));
		secondaryOutput = InventoryUtils.loadFromNBT(nbtTags.func_74775_l("secondaryOutput"));
		secondaryChance = nbtTags.func_74769_h("secondaryChance");
	}

	public ChanceOutput(ItemStack primary)
	{
		primaryOutput = primary;
	}

	public boolean checkSecondary()
	{
		return rand.nextDouble() <= secondaryChance;
	}

	public boolean hasPrimary()
	{
		return !primaryOutput.func_190926_b();
	}

	public boolean hasSecondary()
	{
		return !secondaryOutput.func_190926_b();
	}

	public boolean applyOutputs(NonNullList<ItemStack> inventory, int primaryIndex, int secondaryIndex, boolean doEmit)
	{
		if(hasPrimary())
		{
			if(inventory.get(primaryIndex).func_190926_b())
			{
				if(doEmit)
				{
					inventory.set(primaryIndex, primaryOutput.func_77946_l());
				}
			} 
			else if(inventory.get(primaryIndex).func_77969_a(primaryOutput) && inventory.get(primaryIndex).func_190916_E() + primaryOutput.func_190916_E() <= inventory.get(primaryIndex).func_77976_d())
			{
				if(doEmit)
				{
					inventory.get(primaryIndex).func_190917_f(primaryOutput.func_190916_E());
				}
			}
			else {
				return false;
			}
		}
		
		if(hasSecondary() && (!doEmit || checkSecondary()))
		{
			if(inventory.get(secondaryIndex).func_190926_b())
			{
				if(doEmit)
				{
					inventory.set(secondaryIndex, secondaryOutput.func_77946_l());
				}
				
				return true;
			} 
			else if(inventory.get(secondaryIndex).func_77969_a(secondaryOutput) && inventory.get(secondaryIndex).func_190916_E() + primaryOutput.func_190916_E() <= inventory.get(secondaryIndex).func_77976_d())
			{
				if(doEmit)
				{
					inventory.get(secondaryIndex).func_190917_f(secondaryOutput.func_190916_E());
				}
				
				return true;
			}
			else {
				return false;
			}
		}

		return true;
	}

	@Override
	public ChanceOutput copy()
	{
		return new ChanceOutput(StackUtils.copy(primaryOutput), StackUtils.copy(secondaryOutput), secondaryChance);
	}
}
