package mekanism.common.recipe;

import mekanism.common.MekanismItems;
import mekanism.common.Tier.BinTier;
import mekanism.common.block.states.BlockStateBasic.BasicBlockType;
import mekanism.common.inventory.InventoryBin;
import mekanism.common.item.ItemProxy;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent.ItemCraftedEvent;

public class BinRecipe implements IRecipe
{
	private static boolean registered;
	
	public BinRecipe()
	{
		if(!registered)
		{
			MinecraftForge.EVENT_BUS.register(this);
			registered = true;
		}
	}

	@Override
	public boolean func_77569_a(InventoryCrafting inv, World world)
	{
		return !func_77572_b(inv).func_190926_b();
	}

	private boolean isBin(ItemStack itemStack)
	{
		if(itemStack.func_190926_b())
		{
			return false;
		}

		return BasicBlockType.get(itemStack) == BasicBlockType.BIN && itemStack.func_190916_E() <= 1;
	}

	@Override
	public ItemStack func_77572_b(InventoryCrafting inv)
	{
		return getResult(inv);
	}

	public ItemStack getResult(IInventory inv)
	{
		ItemStack bin = ItemStack.field_190927_a;

		for(int i = 0; i < inv.func_70302_i_(); i++)
		{
			ItemStack stack = inv.func_70301_a(i);

			if(isBin(stack))
			{
				if(!bin.func_190926_b())
				{
					return ItemStack.field_190927_a;
				}

				bin = stack.func_77946_l();
			}
		}

		if(bin.func_190926_b() || bin.func_190916_E() > 1)
		{
			return ItemStack.field_190927_a;
		}

		ItemStack addStack = ItemStack.field_190927_a;

		for(int i = 0; i < 9; i++)
		{
			ItemStack stack = inv.func_70301_a(i);

			if(!stack.func_190926_b() && !isBin(stack))
			{
				if(!addStack.func_190926_b())
				{
					return ItemStack.field_190927_a;
				}

				addStack = stack.func_77946_l();
			}
		}

		InventoryBin binInv = new InventoryBin(bin);

		if(!addStack.func_190926_b())
		{
			if(!(addStack.func_77973_b() instanceof ItemProxy))
			{
				if(!binInv.getItemType().func_190926_b() && !binInv.getItemType().func_77969_a(addStack))
				{
					return ItemStack.field_190927_a;
				}
	
				binInv.add(addStack);
			}
			
			return bin;
		}
		else {
			return binInv.removeStack();
		}
	}

	@Override
	public int func_77570_a()
	{
		return 0;
	}

	@Override
	public ItemStack func_77571_b()
	{
		return ItemStack.field_190927_a;
	}

	@Override
	public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv)
	{
		return ForgeHooks.defaultRecipeGetRemainingItems(inv);
	}

	@SubscribeEvent
	public void onCrafting(ItemCraftedEvent event)
	{
		if(!getResult(event.craftMatrix).func_190926_b())
		{
			if(!isBin(event.crafting))
			{
				for(int i = 0; i < event.craftMatrix.func_70302_i_(); i++)
				{
					if(isBin(event.craftMatrix.func_70301_a(i)))
					{
						ItemStack bin = event.craftMatrix.func_70301_a(i);
						InventoryBin inv = new InventoryBin(bin.func_77946_l());

						int size = inv.getItemCount();

						ItemStack testRemove = inv.removeStack();
						int newCount = size-(!testRemove.func_190926_b() ? testRemove.func_190916_E() : 0);
						
						if(inv.getTier() == BinTier.CREATIVE)
						{
							newCount = size;
						}

						ItemDataUtils.setInt(bin, "newCount", newCount);
					}
				}
			}
			else {
				int bin = -1;
				int other = -1;

				for(int i = 0; i < event.craftMatrix.func_70302_i_(); i++)
				{
					if(isBin(event.craftMatrix.func_70301_a(i)))
					{
						bin = i;
					}
					else if(!isBin(event.craftMatrix.func_70301_a(i)) && !event.craftMatrix.func_70301_a(i).func_190926_b())
					{
						other = i;
					}
				}

				ItemStack binStack = event.craftMatrix.func_70301_a(bin);
				ItemStack otherStack = event.craftMatrix.func_70301_a(other);

				ItemStack testRemain = new InventoryBin(binStack.func_77946_l()).add(otherStack.func_77946_l());

				if(!testRemain.func_190926_b() && testRemain.func_190916_E() > 0)
				{
					ItemStack proxy = new ItemStack(MekanismItems.ItemProxy);
					((ItemProxy)proxy.func_77973_b()).setSavedItem(proxy, testRemain.func_77946_l());
					event.craftMatrix.func_70299_a(other, proxy);
				}
				else {
					event.craftMatrix.func_70299_a(other, ItemStack.field_190927_a);
				}
			}
		}
	}
}
