package mekanism.common.network;

import io.netty.buffer.ByteBuf;
import mekanism.api.Pos3D;
import mekanism.common.PacketHandler;
import mekanism.common.network.PacketEntityMove.EntityMoveMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketEntityMove implements IMessageHandler<EntityMoveMessage, IMessage>
{
	@Override
	public IMessage onMessage(EntityMoveMessage message, MessageContext context) 
	{
		EntityPlayer player = PacketHandler.getPlayer(context);
		
		PacketHandler.handlePacket(new Runnable() {
			@Override
			public void run()
			{
				Entity entity = player.field_70170_p.func_73045_a(message.entityId);
				
				if(entity != null)
				{
					entity.func_70012_b(message.pos.field_72450_a, message.pos.field_72448_b, message.pos.field_72449_c, entity.field_70177_z, entity.field_70125_A);
				}
			}
		}, player);
				
		return null;
	}
	
	public static class EntityMoveMessage implements IMessage
	{
		public int entityId;
		
		public Pos3D pos;
		
		public EntityMoveMessage() {}
	
		public EntityMoveMessage(Entity e)
		{
			entityId = e.func_145782_y();
			pos = new Pos3D(e);
		}
	
		@Override
		public void toBytes(ByteBuf dataStream)
		{
			dataStream.writeInt(entityId);

			dataStream.writeFloat((float)pos.field_72450_a);
			dataStream.writeFloat((float)pos.field_72448_b);
			dataStream.writeFloat((float)pos.field_72449_c);
		}
	
		@Override
		public void fromBytes(ByteBuf dataStream)
		{
			entityId = dataStream.readInt();
			
			pos = new Pos3D(dataStream.readFloat(), dataStream.readFloat(), dataStream.readFloat());
		}
	}
}
