package mekanism.common.item;

import mekanism.common.Resource;
import mekanism.common.base.IMetaItem;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class ItemShard extends ItemMekanism implements IMetaItem
{
	public ItemShard()
	{
		super();
		func_77627_a(true);
	}

	@Override
	public String getTexture(int meta)
	{
		return Resource.values()[meta].getName() + "Shard";
	}
	
	@Override
	public int getVariants()
	{
		return Resource.values().length;
	}

	@Override
	public void func_150895_a(Item item, CreativeTabs tabs, NonNullList<ItemStack> itemList)
	{
		for(int counter = 0; counter < Resource.values().length; counter++)
		{
			itemList.add(new ItemStack(item, 1, counter));
		}
	}

	@Override
	public String func_77667_c(ItemStack item)
	{
		if(item.func_77952_i() <= Resource.values().length-1)
		{
			return "item." + Resource.values()[item.func_77952_i()].getName().toLowerCase() + "Shard";
		}
		
		return "Invalid";
	}
}
