package mekanism.common.item;

import mekanism.common.base.IMetaItem;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class ItemOtherDust extends ItemMekanism implements IMetaItem
{
	public static String[] subtypes = {"Diamond", "Steel", "null", "Sulfur",
									   "Lithium", "RefinedObsidian", "Obsidian"};
	
	public ItemOtherDust()
	{
		super();
		func_77627_a(true);
	}
	
	@Override
	public String getTexture(int meta)
	{
		if(meta == 2)
		{
			return null;
		}
		
		return subtypes[meta] + "Dust";
	}
	
	@Override
	public int getVariants()
	{
		return subtypes.length;
	}

	@Override
	public void func_150895_a(Item item, CreativeTabs tabs, NonNullList<ItemStack> itemList)
	{
		for(int counter = 0; counter < subtypes.length; counter++)
		{
			if(counter != 2)
			{
				itemList.add(new ItemStack(this, 1, counter));
			}
		}
	}

	@Override
	public String func_77667_c(ItemStack item)
	{
		return "item." + subtypes[item.func_77952_i()].toLowerCase() + "Dust";
	}
}
