package mekanism.common.item;

import java.util.HashSet;
import java.util.Set;

import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.IHeatTransfer;
import mekanism.api.MekanismAPI;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.TransmitterNetworkRegistry;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.util.CapabilityUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class ItemNetworkReader extends ItemEnergized
{
	public static double ENERGY_PER_USE = 400;

	public ItemNetworkReader()
	{
		super(60000);
	}

	@Override
	public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand)
	{
		ItemStack stack = player.func_184586_b(hand);
		
		if(!world.field_72995_K)
		{
			TileEntity tileEntity = world.func_175625_s(pos);
			boolean drain = !player.field_71075_bZ.field_75098_d;

			if(getEnergy(stack) >= ENERGY_PER_USE && tileEntity != null)
			{
				if(CapabilityUtils.hasCapability(tileEntity, Capabilities.GRID_TRANSMITTER_CAPABILITY, side.func_176734_d()))
				{
					if(drain) setEnergy(stack, getEnergy(stack)-ENERGY_PER_USE);
	
					IGridTransmitter transmitter = CapabilityUtils.getCapability(tileEntity, Capabilities.GRID_TRANSMITTER_CAPABILITY, side.func_176734_d());
	
					player.func_145747_a(new TextComponentString(EnumColor.GREY + "------------- " + EnumColor.DARK_BLUE + "[Mekanism]" + EnumColor.GREY + " -------------"));
					player.func_145747_a(new TextComponentString(EnumColor.GREY + " *Transmitters: " + EnumColor.DARK_GREY + transmitter.getTransmitterNetworkSize()));
					player.func_145747_a(new TextComponentString(EnumColor.GREY + " *Acceptors: " + EnumColor.DARK_GREY + transmitter.getTransmitterNetworkAcceptorSize()));
					player.func_145747_a(new TextComponentString(EnumColor.GREY + " *Needed: " + EnumColor.DARK_GREY + transmitter.getTransmitterNetworkNeeded()));
					player.func_145747_a(new TextComponentString(EnumColor.GREY + " *Buffer: " + EnumColor.DARK_GREY + transmitter.getTransmitterNetworkBuffer()));
					player.func_145747_a(new TextComponentString(EnumColor.GREY + " *Throughput: " + EnumColor.DARK_GREY + transmitter.getTransmitterNetworkFlow()));
					player.func_145747_a(new TextComponentString(EnumColor.GREY + " *Capacity: " + EnumColor.DARK_GREY + transmitter.getTransmitterNetworkCapacity()));
					
					if(CapabilityUtils.hasCapability(tileEntity, Capabilities.HEAT_TRANSFER_CAPABILITY, side.func_176734_d()))
					{
						IHeatTransfer transfer = CapabilityUtils.getCapability(tileEntity, Capabilities.HEAT_TRANSFER_CAPABILITY, side.func_176734_d());
						player.func_145747_a(new TextComponentString(EnumColor.GREY + " *Temperature: " + EnumColor.DARK_GREY + transfer.getTemp() + "K above ambient"));
					}
					
					player.func_145747_a(new TextComponentString(EnumColor.GREY + "------------- " + EnumColor.DARK_BLUE + "[=======]" + EnumColor.GREY + " -------------"));
					
					return EnumActionResult.SUCCESS;
				}
				else if(CapabilityUtils.hasCapability(tileEntity, Capabilities.HEAT_TRANSFER_CAPABILITY, side.func_176734_d()))
				{
					if(drain) setEnergy(stack, getEnergy(stack)-ENERGY_PER_USE);

					IHeatTransfer transfer = CapabilityUtils.getCapability(tileEntity, Capabilities.HEAT_TRANSFER_CAPABILITY, side.func_176734_d());
					player.func_145747_a(new TextComponentString(EnumColor.GREY + "------------- " + EnumColor.DARK_BLUE + "[Mekanism]" + EnumColor.GREY + " -------------"));
					player.func_145747_a(new TextComponentString(EnumColor.GREY + " *Temperature: " + EnumColor.DARK_GREY + transfer.getTemp() + "K above ambient"));
					player.func_145747_a(new TextComponentString(EnumColor.GREY + "------------- " + EnumColor.DARK_BLUE + "[=======]" + EnumColor.GREY + " -------------"));

					return EnumActionResult.SUCCESS;
				}
				else {
					if(drain) setEnergy(stack, getEnergy(stack)-ENERGY_PER_USE);
					
					Set<DynamicNetwork> iteratedNetworks = new HashSet<>();
					
					for(EnumFacing iterSide : EnumFacing.field_82609_l)
					{
						Coord4D coord = Coord4D.get(tileEntity).offset(iterSide);

						TileEntity tile = coord.getTileEntity(world);
						
						if(tile != null && CapabilityUtils.hasCapability(tile, Capabilities.GRID_TRANSMITTER_CAPABILITY, iterSide.func_176734_d()))
						{
							IGridTransmitter transmitter = CapabilityUtils.getCapability(tile, Capabilities.GRID_TRANSMITTER_CAPABILITY, iterSide.func_176734_d());
							
							if(transmitter.getTransmitterNetwork().possibleAcceptors.containsKey(coord.offset(iterSide.func_176734_d())) && !iteratedNetworks.contains(transmitter.getTransmitterNetwork()))
							{
								player.func_145747_a(new TextComponentString(EnumColor.GREY + "------------- " + EnumColor.DARK_BLUE + "[" + transmitter.getTransmissionType().getName() + "]" + EnumColor.GREY + " -------------"));
								player.func_145747_a(new TextComponentString(EnumColor.GREY + " *Connected sides: " + EnumColor.DARK_GREY + transmitter.getTransmitterNetwork().acceptorDirections.get(coord.offset(iterSide.func_176734_d()))));
								player.func_145747_a(new TextComponentString(EnumColor.GREY + "------------- " + EnumColor.DARK_BLUE + "[=======]" + EnumColor.GREY + " -------------"));
								
								iteratedNetworks.add(transmitter.getTransmitterNetwork());
							}
						}
					}
					
					return EnumActionResult.SUCCESS;
				}
			}

			if(player.func_70093_af() && MekanismAPI.debug)
			{
				String[] strings = TransmitterNetworkRegistry.getInstance().toStrings();
				player.func_145747_a(new TextComponentString(EnumColor.GREY + "---------- " + EnumColor.DARK_BLUE + "[Mekanism Debug]" + EnumColor.GREY + " ----------"));

				for(String s : strings)
				{
					player.func_145747_a(new TextComponentString(EnumColor.DARK_GREY + s));
				}

				player.func_145747_a(new TextComponentString(EnumColor.GREY + "------------- " + EnumColor.DARK_BLUE + "[=======]" + EnumColor.GREY + " -------------"));
			}
		}

		return EnumActionResult.PASS;
	}

	@Override
	public boolean canSend(ItemStack itemstack)
	{
		return false;
	}
}
