package mekanism.common.item;

import java.util.List;

import mekanism.api.EnumColor;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasItem;
import mekanism.client.render.ModelCustomArmor;
import mekanism.client.render.ModelCustomArmor.ArmorModel;
import mekanism.common.Mekanism;
import mekanism.common.MekanismFluids;
import mekanism.common.MekanismItems;
import mekanism.common.config.MekanismConfig.general;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import net.minecraftforge.common.ISpecialArmor.ArmorProperties;

public class ItemJetpack extends ItemArmor implements IGasItem, ISpecialArmor
{
	public int TRANSFER_RATE = 16;

	public ItemJetpack()
	{
		super(EnumHelper.addArmorMaterial("JETPACK", "jetpack", 0, new int[] {0, 0, 0, 0}, 0, SoundEvents.field_187719_p, 0), 0, EntityEquipmentSlot.CHEST);
		func_77637_a(Mekanism.tabMekanism);
	}
	
	@Override
	public boolean showDurabilityBar(ItemStack stack)
	{
		return true;
	}
	
	@Override
	public double getDurabilityForDisplay(ItemStack stack)
	{
		return 1D-((getGas(stack) != null ? (double)getGas(stack).amount : 0D)/(double)getMaxGas(stack));
	}
	
	@Override
	public int getRGBDurabilityForDisplay(ItemStack stack)
    {
        return MathHelper.func_181758_c(Math.max(0.0F, (float)(1-getDurabilityForDisplay(stack))) / 3.0F, 1.0F, 1.0F);
    }

	@Override
	public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag)
	{
		GasStack gasStack = getGas(itemstack);

		if(gasStack == null)
		{
			list.add(LangUtils.localize("tooltip.noGas") + ".");
		}
		else {
			list.add(LangUtils.localize("tooltip.stored") + " " + gasStack.getGas().getLocalizedName() + ": " + gasStack.amount);
		}

		list.add(EnumColor.GREY + LangUtils.localize("tooltip.mode") + ": " + EnumColor.GREY + getMode(itemstack).getName());
	}

	@Override
	public boolean isValidArmor(ItemStack stack, EntityEquipmentSlot armorType, Entity entity)
	{
		return armorType == EntityEquipmentSlot.CHEST;
	}

	@Override
	public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type)
	{
		return "mekanism:render/NullArmor.png";
	}

	@Override
	@SideOnly(Side.CLIENT)
	public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default)
	{
		ModelCustomArmor model = ModelCustomArmor.INSTANCE;

		if(this == MekanismItems.Jetpack)
		{
			model.modelType = ArmorModel.JETPACK;
		}
		else if(this == MekanismItems.ArmoredJetpack)
		{
			model.modelType = ArmorModel.ARMOREDJETPACK;
		}

		return model;
	}

	public void incrementMode(ItemStack stack)
	{
		setMode(stack, getMode(stack).increment());
	}

	public void useGas(ItemStack stack)
	{
		setGas(stack, new GasStack(getGas(stack).getGas(), getGas(stack).amount-1));
	}

	@Override
	public int getMaxGas(ItemStack itemstack)
	{
		return general.maxJetpackGas;
	}

	@Override
	public int getRate(ItemStack itemstack)
	{
		return TRANSFER_RATE;
	}

	@Override
	public int addGas(ItemStack itemstack, GasStack stack)
	{
		if(getGas(itemstack) != null && getGas(itemstack).getGas() != stack.getGas())
		{
			return 0;
		}

		if(stack.getGas() != MekanismFluids.Hydrogen)
		{
			return 0;
		}

		int toUse = Math.min(getMaxGas(itemstack)-getStored(itemstack), Math.min(getRate(itemstack), stack.amount));
		setGas(itemstack, new GasStack(stack.getGas(), getStored(itemstack)+toUse));

		return toUse;
	}

	@Override
	public GasStack removeGas(ItemStack itemstack, int amount)
	{
		return null;
	}

	public int getStored(ItemStack itemstack)
	{
		return getGas(itemstack) != null ? getGas(itemstack).amount : 0;
	}

	@Override
	public boolean canReceiveGas(ItemStack itemstack, Gas type)
	{
		return type == MekanismFluids.Hydrogen;
	}

	@Override
	public boolean canProvideGas(ItemStack itemstack, Gas type)
	{
		return false;
	}

	public JetpackMode getMode(ItemStack stack)
	{
		return JetpackMode.values()[ItemDataUtils.getInt(stack, "mode")];
	}

	public void setMode(ItemStack stack, JetpackMode mode)
	{
		ItemDataUtils.setInt(stack, "mode", mode.ordinal());
	}

	@Override
	public GasStack getGas(ItemStack itemstack)
	{
		return GasStack.readFromNBT(ItemDataUtils.getCompound(itemstack, "stored"));
	}

	@Override
	public void setGas(ItemStack itemstack, GasStack stack)
	{
		if(stack == null || stack.amount == 0)
		{
			ItemDataUtils.removeData(itemstack, "stored");
		}
		else {
			int amount = Math.max(0, Math.min(stack.amount, getMaxGas(itemstack)));
			GasStack gasStack = new GasStack(stack.getGas(), amount);

			ItemDataUtils.setCompound(itemstack, "stored", gasStack.write(new NBTTagCompound()));
		}
	}

	public ItemStack getEmptyItem()
	{
		ItemStack empty = new ItemStack(this);
		setGas(empty, null);
		return empty;
	}

	@Override
	public void func_150895_a(Item item, CreativeTabs tabs, NonNullList<ItemStack> list)
	{
		ItemStack empty = new ItemStack(this);
		setGas(empty, null);
		list.add(empty);

		ItemStack filled = new ItemStack(this);
		setGas(filled, new GasStack(MekanismFluids.Hydrogen, ((IGasItem)filled.func_77973_b()).getMaxGas(filled)));
		list.add(filled);
	}

	public static enum JetpackMode
	{
		NORMAL("tooltip.jetpack.regular", EnumColor.DARK_GREEN),
		HOVER("tooltip.jetpack.hover", EnumColor.DARK_AQUA),
		DISABLED("tooltip.jetpack.disabled", EnumColor.DARK_RED);

		private String unlocalized;
		private EnumColor color;

		private JetpackMode(String s, EnumColor c)
		{
			unlocalized = s;
			color = c;
		}

		public JetpackMode increment()
		{
			return ordinal() < values().length-1 ? values()[ordinal()+1] : values()[0];
		}

		public String getName()
		{
			return color + LangUtils.localize(unlocalized);
		}
	}

	@Override
	public ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot)
	{
		if(this == MekanismItems.Jetpack)
		{
			return new ArmorProperties(0, 0, 0);
		}
		else if(this == MekanismItems.ArmoredJetpack)
		{
			return new ArmorProperties(1, general.armoredJetpackDamageRatio, general.armoredJetpackDamageMax);
		}

		return new ArmorProperties(0, 0, 0);
	}

	@Override
	public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot)
	{
		if(armor.func_77973_b() == MekanismItems.Jetpack)
		{
			return 0;
		}
		else if(armor.func_77973_b() == MekanismItems.ArmoredJetpack)
		{
			return 12;
		}

		return 0;
	}

	@Override
	public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {}
}
