package mekanism.common.item;

import mekanism.common.Mekanism;
import mekanism.common.base.IMetaItem;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class ItemHDPE extends ItemMekanism implements IMetaItem
{
	public ItemHDPE()
	{
		super();
		func_77627_a(true);
		func_77637_a(Mekanism.tabMekanism);
	}

	@Override
	public String getTexture(int meta)
	{
		return PlasticItem.values()[meta].getName();
	}
	
	@Override
	public int getVariants()
	{
		return PlasticItem.values().length;
	}
	
	@Override
	public void func_150895_a(Item item, CreativeTabs tabs, NonNullList<ItemStack> itemList)
	{
		for(int counter = 0; counter < PlasticItem.values().length; counter++)
		{
			itemList.add(new ItemStack(item, 1, counter));
		}
	}

	@Override
	public String func_77667_c(ItemStack item)
	{
		return "item." + PlasticItem.values()[item.func_77952_i()].getName();
	}

	public enum PlasticItem
	{
		PELLET("HDPEPellet"),
		ROD("HDPERod"),
		SHEET("HDPESheet"),
		STICK("PlaStick");

		private String name;

		private PlasticItem(String itemName)
		{
			name = itemName;
		}

		public String getName()
		{
			return name;
		}
	}
}
