package mekanism.common.item;

import io.netty.buffer.ByteBuf;

import java.util.List;

import mekanism.api.EnumColor;
import mekanism.common.base.IItemNetwork;
import mekanism.common.item.ItemConfigurator.ConfiguratorMode;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class ItemElectricBow extends ItemEnergized implements IItemNetwork
{
	public ItemElectricBow()
	{
		super(120000);
		func_77664_n();
	}

	@Override
	public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag)
	{
		super.func_77624_a(itemstack, entityplayer, list, flag);
		
		list.add(EnumColor.PINK + LangUtils.localize("tooltip.fireMode") + ": " + EnumColor.GREY + LangUtils.transOnOff(getFireState(itemstack)));
	}

	@Override
	public void func_77615_a(ItemStack itemstack, World world, EntityLivingBase entityLiving, int itemUseCount)
	{
		if(entityLiving instanceof EntityPlayer && getEnergy(itemstack) > 0)
		{
			EntityPlayer player = (EntityPlayer)entityLiving;
			boolean flag = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a(Enchantments.field_185312_x, itemstack) > 0;
			ItemStack ammo = findAmmo(player);
			
			int maxItemUse = func_77626_a(itemstack) - itemUseCount;
            maxItemUse = ForgeEventFactory.onArrowLoose(itemstack, world, player, maxItemUse, !itemstack.func_190926_b() || flag);
			if(maxItemUse < 0) return;

			if(flag || !ammo.func_190926_b())
			{
				if(ammo.func_190926_b())
				{
					ammo = new ItemStack(Items.field_151032_g);
				}
				
				float f = maxItemUse / 20F;
				f = (f * f + f * 2.0F) / 3F;

				if(f < 0.1D)
				{
					return;
				}

				if(f > 1.0F)
				{
					f = 1.0F;
				}
				
				boolean noConsume = flag && itemstack.func_77973_b() instanceof ItemArrow;

				if(!world.field_72995_K)
				{
                    ItemArrow itemarrow = (ItemArrow)(ammo.func_77973_b() instanceof ItemArrow ? ammo.func_77973_b() : Items.field_151032_g);
                    EntityArrow entityarrow = itemarrow.func_185052_a(world, itemstack, player);
                    entityarrow.func_184547_a(player, player.field_70125_A, player.field_70177_z, 0.0F, f * 3.0F, 1.0F);
				
    				if(f == 1.0F)
    				{
    					entityarrow.func_70243_d(true);
    				}
    				
    				if(!player.field_71075_bZ.field_75098_d)
    				{
    					setEnergy(itemstack, getEnergy(itemstack) - (getFireState(itemstack) ? 1200 : 120));
    				}
    				
    				if(noConsume)
                    {
                        entityarrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                    }
    				
					entityarrow.func_70015_d(getFireState(itemstack) ? 100 : 0);
    				
    				world.func_72838_d(entityarrow);
				}
				
				world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0F, 1.0F / (field_77697_d.nextFloat() * 0.4F + 1.2F) + f * 0.5F);

                if(!noConsume)
                {
                    ammo.func_190918_g(1);

                    if(ammo.func_190916_E() == 0)
                    {
                    	player.field_71071_by.func_184437_d(ammo);
                    }
                }

                player.func_71029_a(StatList.func_188057_b(this));
			}
		}
	}

	@Override
	public int func_77626_a(ItemStack itemstack)
	{
		return 72000;
	}

	@Override
	public EnumAction func_77661_b(ItemStack itemstack)
	{
		return EnumAction.BOW;
	}
	
	private ItemStack findAmmo(EntityPlayer player)
    {
        if(isArrow(player.func_184586_b(EnumHand.OFF_HAND)))
        {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        else if(isArrow(player.func_184586_b(EnumHand.MAIN_HAND)))
        {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        else {
            for(int i = 0; i < player.field_71071_by.func_70302_i_(); ++i)
            {
                ItemStack itemstack = player.field_71071_by.func_70301_a(i);

                if(isArrow(itemstack))
                {
                    return itemstack;
                }
            }

            return ItemStack.field_190927_a;
        }
    }

    protected boolean isArrow(ItemStack stack)
    {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemArrow;
    }

	@Override
	public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand)
	{
		ItemStack itemStackIn = playerIn.func_184586_b(hand);
		boolean flag = !findAmmo(playerIn).func_190926_b();

		ActionResult<ItemStack> ret = ForgeEventFactory.onArrowNock(itemStackIn, worldIn, playerIn, hand, flag);
		if(ret != null) return ret;

		if(!playerIn.field_71075_bZ.field_75098_d && !flag)
		{
			return !flag ? new ActionResult(EnumActionResult.FAIL, itemStackIn) : new ActionResult(EnumActionResult.PASS, itemStackIn);
		}
		else {
			playerIn.func_184598_c(hand);
			return new ActionResult(EnumActionResult.SUCCESS, itemStackIn);
		}
	}

	public void setFireState(ItemStack itemstack, boolean state)
	{
		ItemDataUtils.setBoolean(itemstack, "fireState", state);
	}

	public boolean getFireState(ItemStack itemstack)
	{
		return ItemDataUtils.getBoolean(itemstack, "fireState");
	}

	@Override
	public boolean canSend(ItemStack itemStack)
	{
		return false;
	}
	
	@Override
	public void handlePacketData(ItemStack stack, ByteBuf dataStream) throws Exception 
	{
		if(FMLCommonHandler.instance().getEffectiveSide().isServer())
		{
			boolean state = dataStream.readBoolean();
			setFireState(stack, state);
		}
	}
}
