package mekanism.common.item;

import mekanism.common.Tier.BaseTier;
import mekanism.common.base.IMetaItem;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class ItemControlCircuit extends ItemMekanism implements IMetaItem
{
	public ItemControlCircuit()
	{
		super();
		func_77627_a(true);
	}

	@Override
	public String getTexture(int meta)
	{
		return BaseTier.values()[meta].getSimpleName() + "ControlCircuit";
	}
	
	@Override
	public int getVariants()
	{
		return BaseTier.values().length-1;
	}
	
	@Override
	public void func_150895_a(Item item, CreativeTabs tabs, NonNullList<ItemStack> itemList)
	{
		for(BaseTier tier : BaseTier.values())
		{
			if(tier.isObtainable())
			{
				itemList.add(new ItemStack(item, 1, tier.ordinal()));
			}
		}
	}

	@Override
	public String func_77667_c(ItemStack item)
	{
		return "item." + BaseTier.values()[item.func_77952_i()].getSimpleName() + "ControlCircuit";
	}
}
