package mekanism.common.item;

import mekanism.api.EnumColor;
import mekanism.common.util.LangUtils;
import net.minecraft.block.Block;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;

public class ItemBlockPlastic extends ItemBlock
{
	public Block metaBlock;

	public ItemBlockPlastic(Block block)
	{
		super(block);
		metaBlock = block;
		func_77627_a(true);
	}

	@Override
	public int func_77647_b(int i)
	{
		return i;
	}

	@Override
	public String func_77653_i(ItemStack stack)
	{
		EnumDyeColor dyeColour = EnumDyeColor.func_176766_a(stack.func_77952_i()&15);
		EnumColor colour = EnumColor.DYES[dyeColour.func_176767_b()];
		String colourName;

        if(I18n.func_94522_b(func_77667_c(stack) + "." + colour.dyeName))
        {
            return LangUtils.localize(func_77667_c(stack) + "." + colour.dyeName);
        }

		if(colour == EnumColor.BLACK)
		{
			colourName = EnumColor.DARK_GREY + colour.getDyeName();
		}
		else {
			colourName = colour.getDyedName();
		}

		return colourName + " " + super.func_77653_i(stack);
	}
}
