package mekanism.common.item;

import java.util.List;

import mekanism.api.EnumColor;
import mekanism.client.MekKeyHandler;
import mekanism.client.MekanismKeyHandler;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

/**
 * Item class for handling multiple ore block IDs.
 * 0: Osmium Ore
 * 1: Copper Ore
 * 2: Tin Ore
 * @author AidanBrady
 *
 */
public class ItemBlockOre extends ItemBlock
{
	public Block metaBlock;

	public ItemBlockOre(Block block)
	{
		super(block);
		metaBlock = block;
		func_77627_a(true);
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag)
	{
		if(!MekKeyHandler.getIsKeyPressed(MekanismKeyHandler.sneakKey))
		{
			list.add("Hold " + EnumColor.AQUA + GameSettings.func_74298_c(MekanismKeyHandler.sneakKey.func_151463_i()) + EnumColor.GREY + " " + LangUtils.localize("tooltip.forDetails") + ".");
		}
		else {
			list.addAll(MekanismUtils.splitTooltip(LangUtils.localize("tooltip." + func_77667_c(itemstack).replace("tile.OreBlock.", "")), itemstack));
		}
	}

	@Override
	public int func_77647_b(int i)
	{
		return i;
	}

	@Override
	public String func_77667_c(ItemStack itemstack)
	{
		String name = "";

		switch(itemstack.func_77952_i())
		{
			case 0:
				name = "OsmiumOre";
				break;
			case 1:
				name = "CopperOre";
				break;
			case 2:
				name = "TinOre";
				break;
			default:
				name = "Unknown";
				break;
		}

		return func_77658_a() + "." + name;
	}
}
