package mekanism.common.item;

import java.util.ArrayList;

import mcmultipart.api.multipart.IMultipart;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.Range4D;
import mekanism.common.Mekanism;
import mekanism.common.network.PacketTileEntity.TileEntityMessage;
import mekanism.common.tile.TileEntityGlowPanel;
import mekanism.common.util.LangUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class ItemBlockGlowPanel extends ItemBlock
{
	public Block metaBlock;
	
	public ItemBlockGlowPanel(Block block)
	{
		super(block);
		metaBlock = block;
		func_77627_a(true);
		func_77637_a(Mekanism.tabMekanism);
	}
	
	@Override
	public int func_77647_b(int i)
	{
		return i;
	}
	
	@Override
	public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState state)
	{
		boolean place = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, state);

		if(place)
		{
			TileEntityGlowPanel tileEntity = (TileEntityGlowPanel)world.func_175625_s(pos);
			EnumColor col = EnumColor.DYES[stack.func_77952_i()];
			
			BlockPos pos1 = pos.func_177972_a(side.func_176734_d());
			
			if(world.isSideSolid(pos1, side))
			{
				tileEntity.setOrientation(side.func_176734_d());
			}
			
			tileEntity.setColour(col);
			
			if(!world.field_72995_K)
			{
				Mekanism.packetHandler.sendToReceivers(new TileEntityMessage(Coord4D.get(tileEntity), tileEntity.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(tileEntity)));
			}
		}

		return place;
	}

	@Override
	public void func_150895_a(Item item, CreativeTabs tab, NonNullList<ItemStack> listToAddTo)
	{
		for(EnumColor color : EnumColor.DYES)
		{
			listToAddTo.add(new ItemStack(item, 1, color.getMetaValue()));
		}
	}

	@Override
	public String func_77653_i(ItemStack stack)
	{
		EnumColor colour = EnumColor.DYES[stack.func_77952_i()];
		String colourName;

        if(I18n.func_94522_b(func_77667_c(stack) + "." + colour.dyeName))
        {
            return LangUtils.localize(func_77667_c(stack) + "." + colour.dyeName);
        }
		
		if(colour == EnumColor.BLACK)
		{
			colourName = EnumColor.DARK_GREY + colour.getDyeName();
		}
		else {
			colourName = colour.getDyedName();
		}

		return colourName + " " + super.func_77653_i(stack);
	}

	@Override
	public boolean func_77629_n_()
	{
		return true;
	}
}
