package mekanism.common.item;

import java.util.List;

import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.Pos3D;
import mekanism.common.base.IMetaItem;
import mekanism.common.entity.EntityBalloon;
import mekanism.common.util.LangUtils;
import net.minecraft.block.BlockDispenser;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBalloon extends ItemMekanism implements IMetaItem
{
	public ItemBalloon()
	{
		super();
		func_77627_a(true);
		BlockDispenser.field_149943_a.func_82595_a(this, new DispenserBehavior());
	}
	
	@Override
	public String getTexture(int meta)
	{
		return "Balloon";
	}
	
	@Override
	public int getVariants()
	{
		return EnumColor.DYES.length;
	}
	
	@SideOnly(Side.CLIENT)
	public int getColorFromItemStack(ItemStack stack, int renderPass)
	{
		EnumColor dye = getColor(stack);
		
		return (int)(dye.getColor(0)*255) << 16 | (int)(dye.getColor(1)*255) << 8 | (int)(dye.getColor(2)*255);
	}

	public EnumColor getColor(ItemStack stack)
	{
		return EnumColor.DYES[stack.func_77952_i()];
	}

	@Override
	public void func_150895_a(Item item, CreativeTabs tabs, NonNullList<ItemStack> list)
	{
		for(int i = 0; i < EnumColor.DYES.length; i++)
		{
			EnumColor color = EnumColor.DYES[i];

			if(color != null)
			{
				ItemStack stack = new ItemStack(this);
				stack.func_77964_b(i);
				list.add(stack);
			}
		}
	}

	@Override
	public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entityplayer, EnumHand hand)
	{
		ItemStack itemstack = entityplayer.func_184586_b(hand);
		
		if(!world.field_72995_K)
		{
			Pos3D pos = new Pos3D(hand == EnumHand.MAIN_HAND ? -0.4 : 0.4, 0, 0.3).func_178785_b(entityplayer.field_70761_aq).translate(new Pos3D(entityplayer));

			world.func_72838_d(new EntityBalloon(world, pos.field_72450_a-0.5, pos.field_72448_b-0.25, pos.field_72449_c-0.5, getColor(itemstack)));
		}

		if(!entityplayer.field_71075_bZ.field_75098_d)
		{
			itemstack.func_190918_g(1);
		}

		return new ActionResult(EnumActionResult.SUCCESS, itemstack);
	}

	@Override
	public String func_77653_i(ItemStack stack)
	{
		EnumColor color = getColor(stack);
        String dyeName = color.getDyedName();

        if(I18n.func_94522_b(func_77667_c(stack) + "." + color.dyeName))
        {
            return LangUtils.localize(func_77667_c(stack) + "." + color.dyeName);
        }

		if(getColor(stack) == EnumColor.BLACK)
		{
			dyeName = EnumColor.DARK_GREY + color.getDyeName();
		}

		return dyeName + " " + LangUtils.localize("tooltip.balloon");
	}

	@Override
	public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ)
	{
		ItemStack stack = player.func_184586_b(hand);
		
		if(player.func_70093_af())
		{
			AxisAlignedBB bound = new AxisAlignedBB(pos, pos.func_177982_a(1, 3, 1));

			List<EntityBalloon> balloonsNear = player.field_70170_p.func_72872_a(EntityBalloon.class, bound);

			if(balloonsNear.size() > 0)
			{
				return EnumActionResult.FAIL;
			}

			if(world.func_180495_p(pos).func_177230_c().func_176200_f(world, pos))
			{
				pos = pos.func_177977_b();
			}
			
			if(!world.isSideSolid(pos, EnumFacing.UP))
			{
				return EnumActionResult.FAIL;
			}

			if(canReplace(world, pos.func_177984_a()) && canReplace(world, pos.func_177981_b(2)))
			{
				world.func_175698_g(pos.func_177984_a());
				world.func_175698_g(pos.func_177981_b(2));

				if(!world.field_72995_K)
				{
					world.func_72838_d(new EntityBalloon(world, new Coord4D(pos, world), getColor(stack)));
					stack.func_190918_g(1);
				}
				
				return EnumActionResult.SUCCESS;
			}

			return EnumActionResult.FAIL;
		}

		return EnumActionResult.PASS;
	}

	@Override
	public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase entity, EnumHand hand)
	{
		if(player.func_70093_af())
		{
			if(!player.field_70170_p.field_72995_K)
			{
				AxisAlignedBB bound = new AxisAlignedBB(entity.field_70165_t - 0.2, entity.field_70163_u - 0.5, entity.field_70161_v - 0.2, entity.field_70165_t + 0.2, entity.field_70163_u + entity.field_70131_O + 4, entity.field_70161_v + 0.2);

				List<EntityBalloon> balloonsNear = player.field_70170_p.func_72872_a(EntityBalloon.class, bound);

				for(EntityBalloon balloon : balloonsNear)
				{
					if(balloon.latchedEntity == entity)
					{
						return true;
					}
				}

				player.field_70170_p.func_72838_d(new EntityBalloon(entity, getColor(stack)));
				stack.func_190918_g(1);
			}

			return true;
		}

		return false;
	}

	private boolean canReplace(World world, BlockPos pos)
	{
		return world.func_175623_d(pos) || world.func_180495_p(pos).func_177230_c().func_176200_f(world, pos);
	}
	
	public class DispenserBehavior extends BehaviorDefaultDispenseItem
	{
		@Override
		public ItemStack func_82487_b(IBlockSource source, ItemStack stack)
		{
			Coord4D coord = new Coord4D(source.func_82615_a(), source.func_82617_b(), source.func_82616_c(), source.func_82618_k().field_73011_w.getDimension());
			EnumFacing side = (EnumFacing)source.func_189992_e().func_177229_b(BlockDispenser.field_176441_a);

			List<EntityLivingBase> entities = source.func_82618_k().func_72872_a(EntityLivingBase.class, coord.offset(side).getBoundingBox());
			boolean latched = false;
			
			for(EntityLivingBase entity : entities)
			{
				AxisAlignedBB bound = new AxisAlignedBB(entity.field_70165_t - 0.2, entity.field_70163_u - 0.5, entity.field_70161_v - 0.2, entity.field_70165_t + 0.2, entity.field_70163_u + entity.field_70131_O + 4, entity.field_70161_v + 0.2);

				List<EntityBalloon> balloonsNear = source.func_82618_k().func_72872_a(EntityBalloon.class, bound);
				boolean hasBalloon = false;
				
				for(EntityBalloon balloon : balloonsNear)
				{
					if(balloon.latchedEntity == entity)
					{
						hasBalloon = true;
					}
				}
				
				if(!hasBalloon)
				{
					source.func_82618_k().func_72838_d(new EntityBalloon(entity, getColor(stack)));
					latched = true;
				}
			}
			
			if(!latched)
			{
				Pos3D pos = new Pos3D(coord).translate(0, -0.5, 0);
				
				switch(side)
				{
					case DOWN:
						pos = pos.translate(0, -2.5, 0);
						break;
					case UP:
						pos = pos.translate(0, 0, 0);
						break;
					case NORTH:
						pos = pos.translate(0, -1, -0.5);
						break;
					case SOUTH:
						pos = pos.translate(0, -1, 0.5);
						break;
					case WEST:
						pos = pos.translate(-0.5, -1, 0);
						break;
					case EAST:
						pos = pos.translate(0.5, -1, 0);
						break;
					default:
						break;
				}
				
				if(!source.func_82618_k().field_72995_K)
				{
					source.func_82618_k().func_72838_d(new EntityBalloon(source.func_82618_k(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, getColor(stack)));
				}
			}
			
			stack.func_190918_g(1);
			
			return stack;
		}
	}
}
