package mekanism.common.item;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.common.config.MekanismConfig.general;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.ListUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

import com.google.common.collect.Multimap;

public class ItemAtomicDisassembler extends ItemEnergized
{
	public double HOE_USAGE = 10 * general.DISASSEMBLER_USAGE;

	public ItemAtomicDisassembler()
	{
		super(1000000);
	}

	@Override
	public boolean canHarvestBlock(IBlockState state, ItemStack stack)
	{
		return state.func_177230_c() != Blocks.field_150357_h;
	}

	@Override
	public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag)
	{
		super.func_77624_a(itemstack, entityplayer, list, flag);

		list.add(LangUtils.localize("tooltip.mode") + ": " + EnumColor.INDIGO + getModeName(itemstack));
		list.add(LangUtils.localize("tooltip.efficiency") + ": " + EnumColor.INDIGO + getEfficiency(itemstack));
	}

	@Override
	public boolean func_77644_a(ItemStack itemstack, EntityLivingBase target, EntityLivingBase attacker)
	{
		if(getEnergy(itemstack) > 0)
		{
			if(attacker instanceof EntityPlayer) 
			{
				target.func_70097_a(DamageSource.func_76365_a((EntityPlayer) attacker), 20);
			} 
			else {
				target.func_70097_a(DamageSource.func_76358_a(attacker), 20);
			}
			
			setEnergy(itemstack, getEnergy(itemstack) - 2000);
		}
		else {
			if(attacker instanceof EntityPlayer) 
			{
				target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)attacker), 4);
			} 
			else {
				target.func_70097_a(DamageSource.func_76358_a(attacker), 4);
			}

		}

		return false;
	}

	@Override
	public float func_150893_a(ItemStack itemstack, IBlockState state)
	{
		return getEnergy(itemstack) != 0 ? getEfficiency(itemstack) : 1F;
	}

	@Override
	public boolean func_179218_a(ItemStack itemstack, World world, IBlockState state, BlockPos pos, EntityLivingBase entityliving)
	{
		if(state.func_185887_b(world, pos) != 0.0D)
		{
			setEnergy(itemstack, getEnergy(itemstack) - (general.DISASSEMBLER_USAGE*getEfficiency(itemstack)));
		}
		else {
			setEnergy(itemstack, getEnergy(itemstack) - (general.DISASSEMBLER_USAGE*(getEfficiency(itemstack))/2));
		}

		return true;
	}

	@Override
	public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player)
	{
		super.onBlockStartBreak(itemstack, pos, player);

		if(!player.field_70170_p.field_72995_K)
		{
			IBlockState state = player.field_70170_p.func_180495_p(pos);
			Block block = state.func_177230_c();
			int meta = block.func_176201_c(state);

			if(block == Blocks.field_150439_ay)
			{
				block = Blocks.field_150450_ax;
			}

			ItemStack stack = new ItemStack(block, 1, meta);
			Coord4D orig = new Coord4D(pos, player.field_70170_p);

			List<String> names = MekanismUtils.getOreDictName(stack);

			boolean isOre = false;

			for(String s : names)
			{
				if(s.startsWith("ore") || s.equals("logWood"))
				{
					isOre = true;
				}
			}

			if(getMode(itemstack) == 3 && isOre && !player.field_71075_bZ.field_75098_d)
			{
				Set<Coord4D> found = new Finder(player.field_70170_p, stack, new Coord4D(pos, player.field_70170_p)).calc();

				for(Coord4D coord : found)
				{
					if(coord.equals(orig) || getEnergy(itemstack) < (general.DISASSEMBLER_USAGE*getEfficiency(itemstack)))
					{
						continue;
					}

					Block block2 = coord.getBlock(player.field_70170_p);

					block2.func_176206_d(player.field_70170_p, coord.getPos(), state);
					player.field_70170_p.func_180498_a(null, 2001, coord.getPos(), Block.func_176210_f(state));
					player.field_70170_p.func_175698_g(coord.getPos());
					block2.func_180663_b(player.field_70170_p, coord.getPos(), state);
					block2.func_176226_b(player.field_70170_p, coord.getPos(), state, 0);

					setEnergy(itemstack, getEnergy(itemstack) - (general.DISASSEMBLER_USAGE*getEfficiency(itemstack)));
				}
			}
		}

		return false;
	}

	@Override
	public boolean func_77662_d()
	{
		return true;
	}

	@Override
	public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entityplayer, EnumHand hand)
	{
		ItemStack itemstack = entityplayer.func_184586_b(hand);
		
		if(entityplayer.func_70093_af())
		{
			if(!world.field_72995_K)
			{
				toggleMode(itemstack);
				entityplayer.func_145747_a(new TextComponentString(EnumColor.DARK_BLUE + "[Mekanism] " + EnumColor.GREY + LangUtils.localize("tooltip.modeToggle") + " " + EnumColor.INDIGO + getModeName(itemstack) + EnumColor.AQUA + " (" + getEfficiency(itemstack) + ")"));
			}
			
			return new ActionResult(EnumActionResult.SUCCESS, itemstack);
		}

		return new ActionResult(EnumActionResult.PASS, itemstack);
	}

	@Override
	public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ)
	{
		ItemStack stack = player.func_184586_b(hand);
		Block block = world.func_180495_p(pos).func_177230_c();
		
		if(!player.func_70093_af() && (block == Blocks.field_150346_d || block == Blocks.field_150349_c || block == Blocks.field_185774_da))
		{
			if(useHoe(stack, player, world, pos, side) == EnumActionResult.FAIL)
			{
				return EnumActionResult.FAIL;
			}

			switch(getEfficiency(stack))
			{
				case 20:
					for(int x1 = -1; x1 <= +1; x1++)
					{
						for(int z1 = -1; z1 <= +1; z1++)
						{
							useHoe(stack, player, world, pos.func_177982_a(x1, 0, z1), side);
						}
					}

					break;
				case 128:
					for(int x1 = -2; x1 <= +2; x1++)
					{
						for(int z1 = -2; z1 <= +2; z1++)
						{
							useHoe(stack, player, world, pos.func_177982_a(x1, 0, z1), side);
						}
					}

					break;
			}

			return EnumActionResult.SUCCESS;
		}

		return EnumActionResult.PASS;
	}

	@SuppressWarnings("incomplete-switch")
	private EnumActionResult useHoe(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumFacing facing)
	{
		if(!playerIn.func_175151_a(pos.func_177972_a(facing), facing, stack))
        {
            return EnumActionResult.FAIL;
        }
        else {
            int hook = net.minecraftforge.event.ForgeEventFactory.onHoeUse(stack, playerIn, worldIn, pos);
            if(hook != 0) return hook > 0 ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;

            IBlockState iblockstate = worldIn.func_180495_p(pos);
            Block block = iblockstate.func_177230_c();

            if(facing != EnumFacing.DOWN && worldIn.func_175623_d(pos.func_177984_a()))
            {
                if(block == Blocks.field_150349_c || block == Blocks.field_185774_da)
                {
                    setBlock(stack, playerIn, worldIn, pos, Blocks.field_150458_ak.func_176223_P());
                    return EnumActionResult.SUCCESS;
                }

                if(block == Blocks.field_150346_d)
                {
                    switch((BlockDirt.DirtType)iblockstate.func_177229_b(BlockDirt.field_176386_a))
                    {
                        case DIRT:
                            setBlock(stack, playerIn, worldIn, pos, Blocks.field_150458_ak.func_176223_P());
                            return EnumActionResult.SUCCESS;
                        case COARSE_DIRT:
                            setBlock(stack, playerIn, worldIn, pos, Blocks.field_150346_d.func_176223_P().func_177226_a(BlockDirt.field_176386_a, BlockDirt.DirtType.DIRT));
                            return EnumActionResult.SUCCESS;
                    }
                }
            }

            return EnumActionResult.PASS;
        }
	}
	
	protected void setBlock(ItemStack stack, EntityPlayer player, World worldIn, BlockPos pos, IBlockState state)
    {
        worldIn.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0F, 1.0F);

        if(!worldIn.field_72995_K)
        {
            worldIn.func_180501_a(pos, state, 11);
            stack.func_77972_a(1, player);
        }
    }

	public int getEfficiency(ItemStack itemStack)
	{
		switch(getMode(itemStack))
		{
			case 0:
				return 20;
			case 1:
				return 8;
			case 2:
				return 128;
			case 3:
				return 20;
			case 4:
				return 0;
		}

		return 0;
	}

	public int getMode(ItemStack itemStack)
	{
		return ItemDataUtils.getInt(itemStack, "mode");
	}

	public String getModeName(ItemStack itemStack)
	{
		int mode = getMode(itemStack);

		switch(mode)
		{
			case 0:
				return LangUtils.localize("tooltip.disassembler.normal");
			case 1:
				return LangUtils.localize("tooltip.disassembler.slow");
			case 2:
				return LangUtils.localize("tooltip.disassembler.fast");
			case 3:
				return LangUtils.localize("tooltip.disassembler.vein");
			case 4:
				return LangUtils.localize("tooltip.disassembler.off");
		}

		return null;
	}

	public void toggleMode(ItemStack itemStack)
	{
		ItemDataUtils.setInt(itemStack, "mode", getMode(itemStack) < 4 ? getMode(itemStack)+1 : 0);
	}

	@Override
	public boolean canSend(ItemStack itemStack)
	{
		return false;
	}
	
	@Override
	public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot)
    {
        Multimap<String, AttributeModifier> multimap = super.func_111205_h(equipmentSlot);

        if(equipmentSlot == EntityEquipmentSlot.MAINHAND)
        {
            multimap.put(SharedMonsterAttributes.field_188790_f.func_111108_a(), new AttributeModifier(field_185050_h, "Weapon modifier", -2.4000000953674316D, 0));
        }

        return multimap;
    }

	public static class Finder
	{
		public World world;

		public ItemStack stack;

		public Coord4D location;

		public Set<Coord4D> found = new HashSet<Coord4D>();

		public static Map<Block, List<Block>> ignoreBlocks = new HashMap<Block, List<Block>>();

		public Finder(World w, ItemStack s, Coord4D loc)
		{
			world = w;
			stack = s;
			location = loc;
		}

		public void loop(Coord4D pointer)
		{
			if(found.contains(pointer) || found.size() > 128)
			{
				return;
			}

			found.add(pointer);

			for(EnumFacing side : EnumFacing.field_82609_l)
			{
				Coord4D coord = pointer.offset(side);

				if(coord.exists(world) && checkID(coord.getBlock(world)) && (coord.getBlockMeta(world) == stack.func_77952_i() || (MekanismUtils.getOreDictName(stack).contains("logWood") && coord.getBlockMeta(world) % 4 == stack.func_77952_i() % 4)))
				{
					loop(coord);
				}
			}
		}

		public Set<Coord4D> calc()
		{
			loop(location);

			return found;
		}

		public boolean checkID(Block b)
		{
			Block origBlock = location.getBlock(world);
			return (ignoreBlocks.get(origBlock) == null && b == origBlock) || (ignoreBlocks.get(origBlock) != null && ignoreBlocks.get(origBlock).contains(b));
		}

		static {
			ignoreBlocks.put(Blocks.field_150450_ax, ListUtils.asList(Blocks.field_150450_ax, Blocks.field_150439_ay));
			ignoreBlocks.put(Blocks.field_150439_ay, ListUtils.asList(Blocks.field_150450_ax, Blocks.field_150439_ay));
		}
	}
}
