package mekanism.common.item;

import mekanism.api.IAlloyInteraction;
import mekanism.common.MekanismItems;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig.general;
import mekanism.common.util.CapabilityUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemAlloy extends ItemMekanism
{
	public ItemAlloy()
	{
		super();
	}
	
	@Override
	public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ)
    {
		TileEntity tile = world.func_175625_s(pos);
		ItemStack stack = player.func_184586_b(hand);
		
		if(general.allowTransmitterAlloyUpgrade && CapabilityUtils.hasCapability(tile, Capabilities.ALLOY_INTERACTION_CAPABILITY, side))
		{
			if(!world.field_72995_K)
			{
				IAlloyInteraction interaction = CapabilityUtils.getCapability(tile, Capabilities.ALLOY_INTERACTION_CAPABILITY, side);
				int ordinal = stack.func_77973_b() == MekanismItems.EnrichedAlloy? 1 : (stack.func_77973_b() == MekanismItems.ReinforcedAlloy ? 2 : 3);
				interaction.onAlloyInteraction(player, hand, stack, ordinal);
			}
			
			return EnumActionResult.SUCCESS;
		}
		
        return EnumActionResult.PASS;
    }
}
